/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.caller.TwoStageSpecial;
import fitlibrary.traverse.workflow.special.SpecialActionContext;
import fitlibrary.traverse.workflow.special.SpecialActionTest;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestSetSymbolNamed
extends SpecialActionTest {
    @Test
    public void setWithValueFromInnerMethod() throws Exception {
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                ((SpecialActionContext)this.one(TestSetSymbolNamed.this.actionContext)).findMethodFromRow(TestSetSymbolNamed.this.initialRow, 2, 0);
                this.will(1.returnValue((Object)TestSetSymbolNamed.this.target));
                ((ICalledMethodTarget)this.one(TestSetSymbolNamed.this.target)).invokeForSpecial(TestSetSymbolNamed.this.subRow, TestSetSymbolNamed.this.testResults, true, TestSetSymbolNamed.this.firstCell);
                this.will(1.returnValue((Object)"234"));
                ((SpecialActionContext)this.one(TestSetSymbolNamed.this.actionContext)).setFitVariable("2nd", "234");
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.setSymbolNamed(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test
    public void innerMethodThrowsException() throws Exception {
        final RuntimeException runtimeException = new RuntimeException();
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                super(string);
                ((SpecialActionContext)this.one(TestSetSymbolNamed.this.actionContext)).findMethodFromRow(TestSetSymbolNamed.this.initialRow, 2, 0);
                this.will(2.returnValue((Object)TestSetSymbolNamed.this.target));
                ((ICalledMethodTarget)this.one(TestSetSymbolNamed.this.target)).invokeForSpecial(TestSetSymbolNamed.this.subRow, TestSetSymbolNamed.this.testResults, true, TestSetSymbolNamed.this.firstCell);
                this.will(2.throwException((Throwable)runtimeException));
                ((Row)this.one(TestSetSymbolNamed.this.initialRow)).error(TestSetSymbolNamed.this.testResults, runtimeException);
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.setSymbolNamed(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test
    public void innerMethodThrowsIgnoredException() throws Exception {
        final IgnoredException ignoredException = new IgnoredException();
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                super(string);
                ((SpecialActionContext)this.one(TestSetSymbolNamed.this.actionContext)).findMethodFromRow(TestSetSymbolNamed.this.initialRow, 2, 0);
                this.will(3.returnValue((Object)TestSetSymbolNamed.this.target));
                ((ICalledMethodTarget)this.one(TestSetSymbolNamed.this.target)).invokeForSpecial(TestSetSymbolNamed.this.subRow, TestSetSymbolNamed.this.testResults, true, TestSetSymbolNamed.this.firstCell);
                this.will(3.throwException((Throwable)ignoredException));
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.setSymbolNamed(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test
    public void setWithValueFromOfOgnl() throws Exception {
        this.context.checking((ExpectationBuilder)new SetExpectations("="){
            {
                ((Row)this.one(TestSetSymbolNamed.this.initialRow)).text(3, TestSetSymbolNamed.this.actionContext);
                this.will(4.returnValue((Object)"1+2"));
                ((SpecialActionContext)this.one(TestSetSymbolNamed.this.actionContext)).setFitVariable("2nd", 3);
            }
        });
        TwoStageSpecial twoStageSpecial = this.special.setSymbolNamed(this.initialRow);
        twoStageSpecial.run(this.testResults);
    }

    @Test(expected=RuntimeException.class)
    public void hasMissingMethod() throws Exception {
        this.context.checking((ExpectationBuilder)new SetExpectations(""){
            {
                ((SpecialActionContext)this.one(TestSetSymbolNamed.this.actionContext)).findMethodFromRow(TestSetSymbolNamed.this.initialRow, 2, 0);
                this.will(5.throwException((Throwable)new RuntimeException()));
            }
        });
        this.special.setSymbolNamed(this.initialRow);
    }

    @Test(expected=MissingCellsException.class)
    public void rowIsTooSmall() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestSetSymbolNamed.this.initialRow)).size();
                this.will(6.returnValue((Object)1));
            }
        });
        this.special.setSymbolNamed(this.initialRow);
    }

    class SetExpectations
    extends Expectations {
        public SetExpectations(String string) throws Exception {
            ((Row)this.allowing(TestSetSymbolNamed.this.initialRow)).size();
            this.will(SetExpectations.returnValue((Object)4));
            ((Row)this.allowing(TestSetSymbolNamed.this.initialRow)).text(2, TestSetSymbolNamed.this.actionContext);
            this.will(SetExpectations.returnValue((Object)string));
            ((Row)this.allowing(TestSetSymbolNamed.this.initialRow)).at(0);
            this.will(SetExpectations.returnValue((Object)TestSetSymbolNamed.this.firstCell));
            ((Row)this.allowing(TestSetSymbolNamed.this.initialRow)).text(1, TestSetSymbolNamed.this.actionContext);
            this.will(SetExpectations.returnValue((Object)"2nd"));
            ((Row)this.allowing(TestSetSymbolNamed.this.initialRow)).fromAt(3);
            this.will(SetExpectations.returnValue((Object)TestSetSymbolNamed.this.subRow));
        }
    }
}

