/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.exception.IgnoredException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.special.DoAction;
import fitlibrary.specify.Point;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestShow {
    Mockery context = new Mockery();
    DoAction action = (DoAction)this.context.mock(DoAction.class);
    GlobalActionScope globalActionScope = new GlobalActionScope();

    @Test
    public void textIsShown() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShow.this.action)).run();
                this.will(1.returnValue((Object)"nz"));
                ((DoAction)this.one(TestShow.this.action)).showResult("nz");
            }
        });
        this.globalActionScope.show(this.action);
    }

    @Test
    public void objectIsShown() throws Exception {
        final Point point = new Point();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShow.this.action)).run();
                this.will(2.returnValue((Object)point));
                ((DoAction)this.one(TestShow.this.action)).showResult(point);
            }
        });
        this.globalActionScope.show(this.action);
    }

    @Test
    public void nothingShownWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShow.this.action)).run();
                this.will(3.returnValue(null));
            }
        });
        this.globalActionScope.show(this.action);
    }

    @Test(expected=Exception.class)
    public void exceptionIsPassedOn() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestShow.this.action)).run();
                this.will(4.throwException((Throwable)new IgnoredException()));
            }
        });
        this.globalActionScope.show(this.action);
    }
}

