/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fitlibrary.utility.CollectionUtility;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestCollectionUtility
extends TestCase {
    public void testNoneAndNone() {
        Iterator iterator = this.none().iterator();
        this.equ(iterator, iterator);
        this.equ(iterator, this.none().iterator());
    }

    public void testOneAndOne() {
        ArrayList arrayList = this.one();
        Iterator iterator = arrayList.iterator();
        this.equ(iterator, iterator);
        this.equ(iterator, new ArrayList(arrayList).iterator());
    }

    public void testOneAndNone() {
        this.notEqu(this.one().iterator(), this.none().iterator());
    }

    public void testTwoAndTwo() {
        ArrayList arrayList = this.two();
        Iterator iterator = arrayList.iterator();
        this.equ(iterator, iterator);
        this.equ(iterator, new ArrayList(arrayList).iterator());
    }

    public void testTwoAndOne() {
        this.notEqu(this.two().iterator(), this.one().iterator());
    }

    public void testTwoAndNone() {
        this.notEqu(this.two().iterator(), this.none().iterator());
    }

    private ArrayList none() {
        return new ArrayList();
    }

    private ArrayList one() {
        ArrayList arrayList = this.none();
        arrayList.add("one");
        return arrayList;
    }

    private ArrayList two() {
        ArrayList arrayList = this.one();
        arrayList.add("two");
        return arrayList;
    }

    private void equ(Iterator iterator, Iterator iterator2) {
        TestCollectionUtility.assertTrue((boolean)this.eq(iterator2, iterator));
        TestCollectionUtility.assertTrue((boolean)this.eq(iterator, iterator));
    }

    private void notEqu(Iterator iterator, Iterator iterator2) {
        TestCollectionUtility.assertFalse((boolean)this.eq(iterator2, iterator));
        TestCollectionUtility.assertFalse((boolean)this.eq(iterator, iterator2));
    }

    private boolean eq(Iterator iterator, Iterator iterator2) {
        return CollectionUtility.equalsIterator(iterator, iterator2);
    }
}

