/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.pdf;

import fitlibrary.PrimitiveArrayFixture;
import fitlibrary.differences.LocalFile;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.Log;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.pdf.PDFParagraphStripper;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoTraverse;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PDFDocument
extends DoTraverse {
    private PDFParagraphStripper stripper = null;
    private PDDocument document;
    private File sourceFile;
    private List<String> paragraphs = null;
    private boolean loaded = false;

    public void open(String file) {
        this.sourceFile = Traverse.getLocalFile((String)file).getFile();
        try {
            this.document = PDDocument.load((File)this.sourceFile);
            this.stripper = new PDFParagraphStripper(this.document);
            this.stripper.setLineSeparator(" ");
            this.selectAllPages();
            this.document.getNumberOfPages();
        }
        catch (IOException e) {
            Log.logAndThrow(e);
        }
    }

    public String text() {
        this.loadParagraphs();
        StringBuilder result = new StringBuilder();
        for (String paragraph : this.getParagraphs()) {
            result.append(paragraph);
            result.append(" ");
        }
        return result.toString();
    }

    private List<String> getParagraphs() {
        return this.paragraphs;
    }

    public String paragraphedText() {
        this.loadParagraphs();
        StringBuilder result = new StringBuilder();
        for (String paragraph : this.getParagraphs()) {
            result.append(paragraph);
            result.append("<br/>");
        }
        return result.toString();
    }

    public PrimitiveArrayFixture paragraphs() {
        this.loadParagraphs();
        return new PrimitiveArrayFixture(this.getParagraphs());
    }

    public PrimitiveArrayFixture paragraphsFromTo(int from, int to) {
        this.loadParagraphs();
        if (from < 0 || from >= this.getParagraphs().size() || to < from || to >= this.getParagraphs().size()) {
            throw new FitLibraryException("Out of bounds: 0 .. " + (this.getParagraphs().size() - 1));
        }
        List<String> subList = this.getParagraphs().subList(from, to + 1);
        return new PrimitiveArrayFixture(subList);
    }

    public String paragraphBelowHeading(String heading) {
        this.loadParagraphs();
        int i = 0;
        while (i < this.getParagraphs().size() - 1) {
            if (this.getParagraphs().get(i).equals(heading)) {
                return this.getParagraphs().get(i + 1);
            }
            ++i;
        }
        throw new FitLibraryException("Heading not found");
    }

    public String getParagraphAt(int i) {
        this.loadParagraphs();
        return this.getParagraphs().get(i);
    }

    public String paragraphAfterContaining(String s) {
        this.loadParagraphs();
        int i = 0;
        while (i < this.getParagraphs().size() - 1) {
            if (this.getParagraphs().get(i).contains(s)) {
                return this.getParagraphs().get(i + 1);
            }
            ++i;
        }
        throw new FitLibraryException("Heading not found");
    }

    public void selectPage(int pageToSelect) {
        this.stripper.setStartPage(pageToSelect);
        this.stripper.setEndPage(pageToSelect);
        this.loaded = false;
    }

    public void selectAllPages() {
        this.stripper.setStartPage(1);
        this.stripper.setEndPage(this.numberOfPages());
        this.loaded = false;
    }

    public int numberOfPages() {
        return this.document.getNumberOfPages();
    }

    public boolean closePDFFile() throws IOException {
        if (this.document != null) {
            this.document.close();
        }
        this.document = null;
        return true;
    }

    public void setBasicParagraphDrop(int basicParagraphDrop) {
        this.stripper.setBasicParagraphDrop(basicParagraphDrop);
        this.loaded = false;
    }

    public void setHeightSpaceFactor(float heightSpaceFactor) {
        this.stripper.setHeightSpaceFactor(heightSpaceFactor);
        this.loaded = false;
    }

    public DomainObjectSetUpTraverse customise() {
        return new DomainObjectSetUpTraverse((Object)this);
    }

    public boolean getShowPdfAsImage() throws IOException {
        ImageWriter imageWriter = this.findImageWriter("png");
        ImageWriteParam writerParams = imageWriter.getDefaultWriteParam();
        if (writerParams.canWriteCompressed()) {
            writerParams.setCompressionMode(2);
            writerParams.setCompressionQuality(1.0f);
        }
        List pages = this.document.getDocumentCatalog().getAllPages();
        String imageFileNameRelativePath = null;
        int pageNumber = 1;
        for (PDPage page : pages) {
            LocalFile localFile;
            ImageInputStream output = null;
            try {
                BufferedImage image = page.convertToImage();
                imageFileNameRelativePath = "images/" + this.sourceFile.getName() + pageNumber++ + ".png";
                output = ImageIO.createImageOutputStream(Traverse.getGlobalFile((String)imageFileNameRelativePath).getFile());
                imageWriter.setOutput(output);
                imageWriter.write(null, new IIOImage(image, null, null), writerParams);
            }
            catch (Throwable throwable) {
                imageWriter.dispose();
                if (output != null) {
                    output.flush();
                    output.close();
                    localFile = Traverse.getLocalFile(imageFileNameRelativePath);
                    this.showAfterTable(localFile.htmlImageLink());
                }
                throw throwable;
            }
            imageWriter.dispose();
            if (output == null) continue;
            output.flush();
            output.close();
            localFile = Traverse.getLocalFile((String)imageFileNameRelativePath);
            this.showAfterTable(localFile.htmlImageLink());
        }
        return true;
    }

    private void loadParagraphs() {
        if (this.loaded) {
            return;
        }
        this.paragraphs = this.stripper.collectParagraphs();
        this.loaded = true;
    }

    private ImageWriter findImageWriter(String imageType) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(imageType);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new FitLibraryException("Error: no writer found for image type '" + imageType + "'");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closePDFFile();
    }
}

