/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.pdf;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.Log;
import fitlibrary.pdf.StringIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;

class PDFParagraphStripper
extends PDFTextStripper {
    private List<String> paragraphs = null;
    StringBuilder paragraph = null;
    StringIterator spacedTextIterator = null;
    TextPosition previousPosition = null;
    private boolean loading = false;
    private int basicParagraphDrop = 6;
    private float heightSpaceFactor = 1.1f;

    public PDFParagraphStripper(PDDocument document) throws IOException {
        this.document = document;
    }

    public List<?> getCharactersByArticle() {
        return super.getCharactersByArticle();
    }

    protected void processTextPosition(TextPosition textPosition) {
        super.processTextPosition(textPosition);
        if (this.loading) {
            this.processPossibleParagraphOrHeading(textPosition);
        }
    }

    public String rawText() {
        try {
            return this.getText(this.document);
        }
        catch (IOException e) {
            Log.logAndThrow(e);
            return "";
        }
    }

    public List<String> collectParagraphs() {
        this.paragraphs = new ArrayList<String>();
        this.paragraph = new StringBuilder();
        this.spacedTextIterator = new StringIterator(this.rawText());
        this.previousPosition = null;
        this.loading = true;
        this.rawText();
        if (this.paragraph.length() > 0) {
            this.paragraphs.add(this.paragraph.toString().trim());
        }
        this.loading = false;
        return this.paragraphs;
    }

    public void setBasicParagraphDrop(int basicParagraphDrop) {
        this.basicParagraphDrop = basicParagraphDrop;
    }

    public void setHeightSpaceFactor(float heightSpaceFactor) {
        this.heightSpaceFactor = heightSpaceFactor;
    }

    protected void processPossibleParagraphOrHeading(TextPosition currentPosition) {
        String rawText = currentPosition.getCharacter();
        int i = 0;
        while (i < rawText.length()) {
            String raw;
            String spaced = this.nextSpacedText();
            if (!spaced.equals(raw = rawText.substring(i, i + 1))) {
                this.paragraph.append(spaced);
                spaced = this.nextSpacedText();
            }
            if (this.isNewParagraph(currentPosition)) {
                this.paragraphs.add(this.paragraph.toString().replaceAll("\n", " ").replaceAll("  ", " ").trim());
                this.paragraph = new StringBuilder();
            }
            this.paragraph.append(raw);
            ++i;
        }
        this.previousPosition = currentPosition;
    }

    private String nextSpacedText() {
        if (!this.spacedTextIterator.hasNext()) {
            throw new FitLibraryException("Insufficient characters");
        }
        return this.spacedTextIterator.next();
    }

    private boolean isNewParagraph(TextPosition currentPosition) {
        if (this.previousPosition == null || currentPosition == null) {
            return false;
        }
        return this.paragraphDrop(currentPosition) || this.differentFontOnNewLine(currentPosition);
    }

    private boolean paragraphDrop(TextPosition currentPosition) {
        float maxHeight = Math.max(currentPosition.getHeight(), this.previousPosition.getHeight());
        float sufficientSpace = (float)this.basicParagraphDrop + maxHeight * this.heightSpaceFactor;
        return currentPosition.getY() - this.previousPosition.getY() > sufficientSpace;
    }

    private boolean differentFontOnNewLine(TextPosition currentPosition) {
        return currentPosition.getY() - this.previousPosition.getY() > (float)this.basicParagraphDrop && this.previousPosition.getHeight() - currentPosition.getHeight() > 2.0f && !this.previousPosition.getFont().getBaseFont().equals(currentPosition.getFont().getBaseFont());
    }
}

