/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.server;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.FixturingLogger;
import fitlibrary.server.ServerConnectionThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.log4j.Logger;

public abstract class HttpServer {
    static Logger logger = FixturingLogger.getLogger(HttpServer.class);
    protected final String id;
    protected final int portNo;
    private Thread thread;
    protected ServerSocket serversocket;
    protected boolean running = false;

    public HttpServer(int portNo, String id) {
        this.portNo = portNo;
        this.id = String.valueOf(id) + portNo;
    }

    public void start() throws IOException {
        logger.trace((Object)("Started on port " + this.portNo));
        this.running = true;
        this.thread = new RequestListenerThread(this.portNo);
        this.thread.setDaemon(false);
        this.thread.start();
    }

    public void stop() throws IOException {
        if (!this.running) {
            throw new FitLibraryException("Not running");
        }
        this.running = false;
        this.thread.interrupt();
        this.serversocket.close();
        logger.trace((Object)("Stopped on port " + this.portNo));
    }

    protected abstract void register(HttpRequestHandlerRegistry var1);

    class RequestListenerThread
    extends Thread {
        private final HttpParams params;
        private final HttpService httpService;

        public RequestListenerThread(int port) throws IOException {
            super(HttpServer.this.id);
            HttpServer.this.serversocket = new ServerSocket(port);
            this.params = new BasicHttpParams();
            this.params.setIntParameter("http.socket.timeout", 5000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpComponents/1.1");
            BasicHttpProcessor httpproc = new BasicHttpProcessor();
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
            HttpRequestHandlerRegistry reqistry = new HttpRequestHandlerRegistry();
            HttpServer.this.register(reqistry);
            this.httpService = new HttpService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
            this.httpService.setParams(this.params);
            this.httpService.setHandlerResolver((HttpRequestHandlerResolver)reqistry);
        }

        @Override
        public void run() {
            logger.trace((Object)("Listening on port " + HttpServer.this.serversocket.getLocalPort()));
            while (!Thread.interrupted()) {
                try {
                    Socket socket = HttpServer.this.serversocket.accept();
                    DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
                    logger.trace((Object)("Incoming connection from " + socket.getInetAddress()));
                    conn.bind(socket, this.params);
                    ServerConnectionThread t = new ServerConnectionThread(HttpServer.this.id, this.httpService, (HttpServerConnection)conn, "" + socket.getInetAddress());
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException ex) {
                    break;
                }
                catch (SocketException e) {
                    if (!HttpServer.this.running) continue;
                    logger.error((Object)("I/O error initialising connection thread: " + e));
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error initialising connection thread: " + e));
                    break;
                }
            }
        }
    }
}

