/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.server;

import fitlibrary.server.HttpServer;
import fitlibrary.server.Recorder;
import fitlibrary.server.RecordingProxyHandler;
import fitlibrary.server.UriMapper;
import java.io.IOException;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;

public class ProxyServer
extends HttpServer {
    private UriMapper uriMapper;
    private Recorder recorder;

    public ProxyServer(int portNumber) throws IOException {
        this(portNumber, new NonMapper(), new NullRecorder());
    }

    public ProxyServer(int portNumber, UriMapper uriMapper, Recorder recorder) throws IOException {
        super(portNumber, "proxy");
        this.uriMapper = uriMapper;
        this.recorder = recorder;
        this.start();
    }

    @Override
    protected void register(HttpRequestHandlerRegistry reqistry) {
        reqistry.register("*", (HttpRequestHandler)new RecordingProxyHandler(this.uriMapper, this.recorder));
    }

    public static void main(String[] args) throws IOException {
        new ProxyServer(Integer.parseInt(args[0]));
    }

    static class NonMapper
    implements UriMapper {
        NonMapper() {
        }

        @Override
        public String map(String uri, String path) {
            return uri;
        }
    }

    static class NullRecorder
    implements Recorder {
        NullRecorder() {
        }

        @Override
        public void record(String uri, String requestContents, String responseContents) {
        }
    }
}

