/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.server;

import fitlibrary.log.FixturingLogger;
import fitlibrary.server.Recorder;
import fitlibrary.server.UriMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class RecordingProxyHandler
implements HttpRequestHandler {
    static Logger logger = FixturingLogger.getLogger(RecordingProxyHandler.class);
    protected HttpClient client = new DefaultHttpClient();
    private UriMapper uriMapper;
    private Recorder recorder;

    public RecordingProxyHandler(UriMapper uriMapper, Recorder recorder) {
        this.uriMapper = uriMapper;
        this.recorder = recorder;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws IOException {
        try {
            RequestLine requestLine = request.getRequestLine();
            logger.trace((Object)("Request: " + requestLine));
            String path = this.extractPath(requestLine.toString());
            String uri = this.uriMapper.map(requestLine.getUri(), path);
            logger.trace((Object)("Request uri: " + uri));
            String host = request.getFirstHeader("Host").getValue();
            switch (this.decodeMethod(requestLine)) {
                case GET: {
                    this.httpGet(response, uri, host);
                    return;
                }
                case HEAD: {
                    this.httpHead(response, uri, host);
                    return;
                }
                case POST: {
                    this.httpPost(request, response, uri, host);
                    return;
                }
                case PUT: 
                case DELETE: 
                case INVALID: {
                    this.error(response, "Not yet implemented");
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    private String extractPath(String requestLine) {
        int start = requestLine.indexOf(" ");
        if (start < 0) {
            return "/";
        }
        int end = requestLine.indexOf(" ", start + 1);
        if (end < 0) {
            return "/";
        }
        return requestLine.substring(start + 1, end);
    }

    private void httpHead(HttpResponse response, String uri, String host) throws IOException {
        HttpHead head = new HttpHead(uri);
        head.setHeader("Host", host);
        HttpResponse reply = this.client.execute((HttpUriRequest)head);
        if (!this.ok(reply.getStatusLine(), response)) {
            return;
        }
        this.traceHeaders("Reply", reply.getAllHeaders());
        response.addHeader(reply.getFirstHeader("Content-Type"));
        response.addHeader("Passed-Thru-Proxy", "true");
        response.setStatusCode(200);
    }

    private void httpGet(HttpResponse response, String uri, String host) throws IOException {
        HttpGet get = new HttpGet(uri);
        get.setHeader("Host", host);
        HttpResponse reply = this.client.execute((HttpUriRequest)get);
        if (!this.ok(reply.getStatusLine(), response)) {
            return;
        }
        this.traceHeaders("Reply", reply.getAllHeaders());
        HttpEntity entity = reply.getEntity();
        response.setEntity(entity);
        response.addHeader(reply.getFirstHeader("Content-Type"));
        response.addHeader("Passed-Thru-Proxy", "true");
        response.setStatusCode(200);
    }

    private void httpPost(HttpRequest request, HttpResponse response, String uri, String host) throws IOException {
        this.traceHeaders("Request", request.getAllHeaders());
        HttpPost post = new HttpPost(uri);
        post.setHeader("Host", host);
        Header soapHeader = request.getFirstHeader("SOAPAction");
        if (soapHeader != null) {
            post.setHeader("SOAPAction", soapHeader.getValue());
        }
        HttpEntity requestEntity = ((HttpEntityEnclosingRequest)request).getEntity();
        String requestContents = EntityUtils.toString((HttpEntity)requestEntity);
        StringEntity outEntity = this.copyOfEntity("Request", requestEntity, requestContents);
        post.setEntity((HttpEntity)outEntity);
        logger.trace((Object)("POST uri: " + post.getURI()));
        HttpResponse reply = this.client.execute((HttpUriRequest)post);
        if (!this.ok(reply.getStatusLine(), response)) {
            return;
        }
        this.traceHeaders("Reply", reply.getAllHeaders());
        String responseContents = this.gatherResponseContentsAndPassOn(response, reply);
        this.recorder.record(uri, requestContents, responseContents);
        response.addHeader("Passed-Thru-Proxy", "true");
        response.setStatusCode(200);
    }

    private String gatherResponseContentsAndPassOn(HttpResponse response, HttpResponse reply) throws IOException, UnsupportedEncodingException {
        HttpEntity responseEntity = reply.getEntity();
        if (responseEntity != null) {
            String responseContents = EntityUtils.toString((HttpEntity)responseEntity);
            logger.trace((Object)("Response contents: " + responseContents));
            StringEntity replyEntity = this.copyOfEntity("Response", responseEntity, responseContents);
            response.setEntity((HttpEntity)replyEntity);
            return responseContents;
        }
        response.setEntity(reply.getEntity());
        return "";
    }

    private StringEntity copyOfEntity(String direction, HttpEntity entity, String contents) throws UnsupportedEncodingException {
        logger.trace((Object)(String.valueOf(direction) + " Contents: " + contents));
        StringEntity replyEntity = new StringEntity(contents);
        replyEntity.setContentType(entity.getContentType());
        replyEntity.setContentEncoding(entity.getContentEncoding());
        return replyEntity;
    }

    private void traceHeaders(String direction, Header[] allHeaders) {
        Header[] headerArray = allHeaders;
        int n = allHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            logger.trace((Object)(String.valueOf(direction) + " Header: " + header.getName() + ": " + header.getValue()));
            ++n2;
        }
    }

    private boolean ok(StatusLine statusLine, HttpResponse response) {
        if (statusLine.getStatusCode() == 200) {
            return true;
        }
        this.error(response, "Received Status code = " + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase());
        return false;
    }

    private void error(HttpResponse response, String error) {
        response.setStatusCode(403);
        EntityTemplate body = this.makeBody(error, "text/html; charset=UTF-8");
        response.setEntity((HttpEntity)body);
        logger.error((Object)error);
    }

    private EntityTemplate makeBody(final String contents, String contentType) {
        EntityTemplate body = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(outstream, "UTF-8");
                writer.write("<html><body>");
                writer.write("<h1>");
                writer.write(contents);
                writer.write("</h1></body></html>");
                writer.flush();
            }
        });
        body.setContentType(contentType);
        return body;
    }

    private MethodType decodeMethod(RequestLine requestLine) {
        String method = requestLine.getMethod().toUpperCase(Locale.ENGLISH);
        if (method.equals("HEAD")) {
            return MethodType.HEAD;
        }
        if (method.equals("GET")) {
            return MethodType.GET;
        }
        if (method.equals("POST")) {
            return MethodType.POST;
        }
        if (method.equals("PUT")) {
            return MethodType.PUT;
        }
        if (method.equals("DELETE")) {
            return MethodType.DELETE;
        }
        return MethodType.INVALID;
    }

    static enum MethodType {
        HEAD,
        GET,
        POST,
        PUT,
        DELETE,
        INVALID;

    }
}

