/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.sh;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.sh.utility.InteractiveFixture;
import fitlibrary.sh.utility.QueueLinesFromStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.concurrent.TimeUnit;

public class ShellFixture
extends InteractiveFixture {
    protected Process process;
    protected QueueLinesFromStream sysErr;

    public boolean asynchronously(String commandLine) throws IOException {
        this.shell(commandLine);
        return true;
    }

    public int synchronously(String commandLine) throws IOException, InterruptedException {
        this.shell(commandLine);
        return this.process.waitFor();
    }

    public void shell(String commandLine) throws IOException {
        this.process = Runtime.getRuntime().exec(commandLine);
        this.sysOut = new QueueLinesFromStream(this.process.getInputStream());
        this.sysErr = new QueueLinesFromStream(this.process.getErrorStream());
        this.sysIn = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        new Thread(this.sysOut).start();
        new Thread(this.sysErr).start();
    }

    public String sysErrLineWaitingFor(long timeout) throws InterruptedException {
        if (this.sysErr == null) {
            throw new FitLibraryException("Not connected");
        }
        String result = this.sysErr.take(timeout, TimeUnit.MILLISECONDS);
        if (result == null) {
            throw new FitLibraryException("timed out");
        }
        return result;
    }

    public String sysErrLine() throws InterruptedException {
        return this.sysErrLineWaitingFor(this.defaultTimeout);
    }

    public String firstMatchingLineWithInSysErr(String pattern) throws InterruptedException {
        return this.firstMatchingLineWithSysErrWaitingFor(pattern, this.defaultTimeout);
    }

    public String firstMatchingLineWithSysErrWaitingFor(String pattern, long timeout) throws InterruptedException {
        if (this.sysOut == null) {
            throw new FitLibraryException("Not connected");
        }
        return this.sysErr.findFirstMatchingLineWaitingFor(".*" + pattern + ".*", timeout, TimeUnit.MILLISECONDS);
    }

    public String outputsRemaining() throws InterruptedException {
        this.sleep(10);
        return "<h3>System Out:</h3><pre>" + this.sysOut.outputRemaining() + "</pre><hr/><h3>System Err:</h3><pre>" + this.sysErr.outputRemaining() + "</pre>";
    }

    public void waitToFinish() throws InterruptedException {
        this.waitToFinish(this.defaultTimeout);
    }

    public void waitToFinish(final long timeout) throws InterruptedException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        ShellFixture.this.process.destroy();
                    }
                }
                finally {
                    ShellFixture.this.process.destroy();
                }
            }
        }).start();
        this.process.waitFor();
    }

    @Override
    protected Object getService() {
        return this.process;
    }
}

