/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.element;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.spider.element.SpiderElement;
import org.openqa.selenium.By;

public class LinkAndFormElement
extends SpiderElement {
    public LinkAndFormElement(AbstractSpiderFixture spiderFixture) {
        super(spiderFixture);
    }

    public boolean click(String locator) {
        try {
            this.findElement(locator).click();
            return true;
        }
        catch (FitLibraryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.problem(e.toString(), locator);
        }
    }

    public boolean clickAndSelectResultingWindow(String locator) {
        return this.window().clickAndSelectResultingWindow(locator);
    }

    public boolean clickOnNamedLink(String linkName) {
        try {
            this.finder().findElement(By.linkText((String)linkName)).click();
        }
        catch (Exception e) {
            throw new FitLibraryException("No such link");
        }
        return true;
    }

    public boolean clickOnPartiallyNamedLink(String linkName) {
        try {
            this.finder().findElement(By.partialLinkText((String)linkName)).click();
        }
        catch (Exception e) {
            throw new FitLibraryException("No such partial link");
        }
        return true;
    }

    public void submit(String locator) {
        try {
            this.findElement(locator).submit();
        }
        catch (RuntimeException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }
}

