/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.traverse.Traverse;
import fitlibrary.ws.client.WebService;
import fitlibrary.ws.message.ContentType;
import fitlibrary.ws.soap.Soap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class WebServicesClientFixture
extends WebService {
    public String toPostText(String url, String s) {
        try {
            return this.postHttp(url, s, ContentType.PLAIN);
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostTextFromFile(String url, String fileName) {
        try {
            return this.toPostText(url, this.readFile(fileName));
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostTextFromRelativeFile(String url, String fileName) {
        try {
            return this.toPostText(url, this.readRelativeFile(fileName));
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toAsPostFullSoap(String url, ContentType contentType, String xmlOut) {
        try {
            this.reply = this.postHttp(url, xmlOut, contentType).trim();
            return this.reply;
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toAsPostFullSoapFromFile(String url, ContentType contentType, String fileName) {
        try {
            return this.toAsPostFullSoap(url, contentType, this.readFile(fileName)).trim();
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toAsPostFullSoapFromRelativeFile(String url, ContentType contentType, String fileName) {
        try {
            return this.toAsPostFullSoap(url, contentType, this.readRelativeFile(fileName)).trim();
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostSoap11(String url, String xmlOut) {
        try {
            this.reply = Soap.unwrap11(this.postHttp(url, Soap.wrap11(xmlOut), ContentType.SOAP11)).trim();
            return this.reply;
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostSoap11FromFile(String url, String fileName) {
        try {
            return this.toPostSoap11(url, this.readFile(fileName));
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostSoap11FromRelativeFile(String url, String fileName) {
        try {
            return this.toPostSoap11(url, this.readRelativeFile(fileName));
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostSoap12(String url, String xmlOut) {
        try {
            this.reply = Soap.unwrap12(this.postHttp(url, Soap.wrap12(xmlOut), ContentType.SOAP12)).trim();
            return this.reply;
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostSoap12FromFile(String url, String fileName) {
        try {
            return this.toPostSoap12(url, this.readFile(fileName));
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String toPostSoap12FromRelativeFile(String url, String fileName) {
        try {
            return this.toPostSoap12(url, this.readRelativeFile(fileName));
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String postingTextWithAndTimeOut(String url, String text, int timeoutInMilliseconds) {
        this.timeout(timeoutInMilliseconds);
        return this.postHttp(url, text, ContentType.PLAIN);
    }

    public String postTextWith(String url, String s) {
        this.showAfterTable("Deprecated: use |''to''|" + url + "|''post text''|" + s + "| instead");
        return this.toPostText(url, s);
    }

    public String postWith(String url, String xmlOut) {
        this.showAfterTable("Deprecated: use |''to''|" + url + "|''post soap11''|" + xmlOut + "| instead");
        return this.toPostSoap11(url, xmlOut);
    }

    public String postTextFromFile(String url, String fileName) {
        this.showAfterTable("Deprecated: use |''to''|" + url + "|''post text from file''|" + fileName + "| instead");
        return this.toPostTextFromFile(url, fileName);
    }

    public String postSoapFromFile(String url, String fileName) {
        this.showAfterTable("Deprecated: use |''to''|" + url + "|''post soap12 from file''|" + fileName + "| instead");
        return this.toPostSoap12FromFile(url, fileName);
    }

    public String postFromFile(String url, String fileName, ContentType contentType) {
        this.showAfterTable("Deprecated: use |''to''|" + url + "|''post full soap from file''|" + fileName + "| instead");
        try {
            return this.toAsPostFullSoapFromFile(url, contentType, this.readFile(fileName));
        }
        catch (IOException e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    private String postHttp(String url, String contents, ContentType contentType) {
        this.httpPost(url, contents, contentType.getContentType(), "utf-8");
        return this.getReply();
    }

    private String readFile(String fileName) throws IOException {
        return this.readFile(new File(fileName));
    }

    private String readRelativeFile(String localFileName) throws IOException {
        return this.readFile(Traverse.getLocalFile((String)localFileName).getFile());
    }

    private String readFile(File file) throws FileNotFoundException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }
}

