/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.requestMatcher;

import fitlibrary.mockWebServices.requestMatcher.FussyRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.ws.message.HttpMessage;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestFussyRequestMatcher {
    protected final Message request = TestFussyRequestMatcher.msg("any string");
    Mockery context = new JUnit4Mockery();
    final RequestMatcher first = (RequestMatcher)this.context.mock(RequestMatcher.class, "first");
    private RequestMatcher failingMatcher = new FussyRequestMatcher(){

        @Override
        public String getExpected() {
            return null;
        }

        @Override
        public boolean match(HttpMessage httpMessage) throws IOException {
            return false;
        }
    };
    private RequestMatcher passingMatcher = new FussyRequestMatcher(){

        @Override
        public String getExpected() {
            return null;
        }

        @Override
        public boolean match(HttpMessage httpMessage) throws IOException {
            return true;
        }
    };

    @Test
    public void andFalseTrue() throws Exception {
        Assert.assertThat((Object)this.failingMatcher.and(this.first).match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void andTrueFalse() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestFussyRequestMatcher.this.first)).match(TestFussyRequestMatcher.this.request);
                this.will(3.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.passingMatcher.and(this.first).match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void andTrueTrue() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestFussyRequestMatcher.this.first)).match(TestFussyRequestMatcher.this.request);
                this.will(4.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.passingMatcher.and(this.first).match(this.request), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void orFalseFalse() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestFussyRequestMatcher.this.first)).match(TestFussyRequestMatcher.this.request);
                this.will(5.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.failingMatcher.or(this.first).match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void orFalseTrue() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestFussyRequestMatcher.this.first)).match(TestFussyRequestMatcher.this.request);
                this.will(6.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.failingMatcher.or(this.first).match(this.request), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void orTrueAny() throws Exception {
        Assert.assertThat((Object)this.passingMatcher.or(this.first).match(this.request), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void notFalse() throws Exception {
        Assert.assertThat((Object)this.failingMatcher.not().match(this.request), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void notTrue() throws Exception {
        Assert.assertThat((Object)this.passingMatcher.not().match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

