/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.PrintTestListener;
import fitnesse.junit.TestHelper;
import fitnesse.responders.run.ResultsListener;
import fitnesse.responders.run.TestSummary;
import junit.framework.Assert;

public class JUnitHelper {
    private final TestHelper helper;
    private int port = 0;

    public void setPort(int port) {
        this.port = port;
    }

    public JUnitHelper(String fitNesseRootPath, String outputPath) {
        this(fitNesseRootPath, outputPath, new PrintTestListener());
    }

    public JUnitHelper(String fitNesseDir, String outputDir, ResultsListener resultsListener) {
        this.helper = new TestHelper(fitNesseDir, outputDir, resultsListener);
    }

    public void setDebugMode(boolean enabled) {
        this.helper.setDebugMode(enabled);
    }

    public void assertTestPasses(String testName) throws Exception {
        this.assertPasses(testName, "test", null);
    }

    public void assertSuitePasses(String suiteName) throws Exception {
        this.assertPasses(suiteName, "suite", null);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter) throws Exception {
        this.assertPasses(suiteName, "suite", suiteFilter);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter, String excludeSuiteFilter) throws Exception {
        this.assertPasses(suiteName, "suite", suiteFilter, excludeSuiteFilter);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter) throws Exception {
        this.assertPasses(pageName, pageType, suiteFilter, null);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter, String excludeSuiteFilter) throws Exception {
        TestSummary summary = this.helper.run(pageName, pageType, suiteFilter, excludeSuiteFilter, this.port);
        Assert.assertEquals((String)"wrong", (int)0, (int)summary.wrong);
        Assert.assertEquals((String)"exceptions", (int)0, (int)summary.exceptions);
        Assert.assertTrue((String)"at least one test executed", (summary.right > 0 ? 1 : 0) != 0);
    }
}

