/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.VelocityFactory;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.run.ExecutionReport;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.templateUtilities.PageTitle;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.responders.testHistory.TestResultRecord;
import fitnesse.wiki.PathParser;
import java.io.File;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import util.FileUtil;

public class PageHistoryResponder
implements SecureResponder {
    private File resultsDirectory;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleResponse response;
    private TestHistory history;
    private String pageName;
    private PageHistory pageHistory;
    private VelocityContext velocityContext;
    private FitNesseContext context;
    private PageTitle pageTitle;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        this.prepareResponse(request);
        if (request.hasInput("resultDate")) {
            return this.tryToMakeTestExecutionReport(request);
        }
        return this.makePageHistoryResponse(request);
    }

    private Response makePageHistoryResponse(Request request) throws Exception {
        this.velocityContext.put("pageHistory", this.pageHistory);
        String velocityTemplate = "pageHistory.vm";
        if (this.formatIsXML(request)) {
            this.response.setContentType("text/xml");
            velocityTemplate = "pageHistoryXML.vm";
        }
        Template template = VelocityFactory.getVelocityEngine().getTemplate(velocityTemplate);
        return this.makeResponseFromTemplate(template);
    }

    private boolean formatIsXML(Request request) {
        return request.getInput("format") != null && request.getInput("format").toString().toLowerCase().equals("xml");
    }

    private Response tryToMakeTestExecutionReport(Request request) throws Exception {
        String date = (String)request.getInput("resultDate");
        Date resultDate = "latest".equals(date) ? this.pageHistory.getLatestDate() : this.dateFormat.parse(date);
        TestResultRecord testResultRecord = this.pageHistory.get(resultDate);
        try {
            return this.makeTestExecutionReportResponse(request, resultDate, testResultRecord);
        }
        catch (Exception e) {
            return this.makeCorruptFileResponse(request);
        }
    }

    private Response makeCorruptFileResponse(Request request) throws Exception {
        return new ErrorResponder("Corrupt Test Result File").makeResponse(this.context, request);
    }

    private Response makeTestExecutionReportResponse(Request request, Date resultDate, TestResultRecord testResultRecord) throws Exception {
        if (this.formatIsXML(request)) {
            return this.generateXMLResponse(testResultRecord.getFile());
        }
        String content = FileUtil.getFileContent(testResultRecord.getFile());
        ExecutionReport report = ExecutionReport.makeReport(content);
        if (report instanceof TestExecutionReport) {
            report.setDate(resultDate);
            return this.generateHtmlTestExecutionResponse((TestExecutionReport)report);
        }
        if (report instanceof SuiteExecutionReport) {
            this.pageTitle.setPageType("Suite History");
            return this.generateHtmlSuiteExecutionResponse((SuiteExecutionReport)report);
        }
        return this.makeCorruptFileResponse(request);
    }

    private Response generateHtmlSuiteExecutionResponse(SuiteExecutionReport report) throws Exception {
        this.velocityContext.put("suiteExecutionReport", report);
        Template template = VelocityFactory.getVelocityEngine().getTemplate("suiteExecutionReport.vm");
        return this.makeResponseFromTemplate(template);
    }

    private Response generateHtmlTestExecutionResponse(TestExecutionReport report) throws Exception {
        this.velocityContext.put("testExecutionReport", report);
        Template template = VelocityFactory.getVelocityEngine().getTemplate("testExecutionReport.vm");
        return this.makeResponseFromTemplate(template);
    }

    private Response generateXMLResponse(File file) throws Exception {
        this.response.setContent(FileUtil.getFileContent(file));
        this.response.setContentType("text/xml");
        return this.response;
    }

    private Response makeResponseFromTemplate(Template template) throws Exception {
        StringWriter writer = new StringWriter();
        template.merge(this.velocityContext, writer);
        this.response.setContent(writer.toString());
        return this.response;
    }

    private void prepareResponse(Request request) {
        this.response = new SimpleResponse();
        if (this.resultsDirectory == null) {
            this.resultsDirectory = this.context.getTestHistoryDirectory();
        }
        this.history = new TestHistory();
        this.pageName = request.getResource();
        this.history.readPageHistoryDirectory(this.resultsDirectory, this.pageName);
        this.pageHistory = this.history.getPageHistory(this.pageName);
        this.velocityContext = new VelocityContext();
        this.pageTitle = this.makePageTitle(request.getResource());
        this.velocityContext.put("pageTitle", this.pageTitle);
    }

    private PageTitle makePageTitle(String resource) {
        return new PageTitle("Test History", PathParser.parse(resource));
    }

    public void setResultsDirectory(File resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

