/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.SlimError;
import fitnesse.slim.converters.ConverterRegistry;
import fitnesse.slim.converters.PropertyEditorConverter;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;

class ConverterSupport {
    ConverterSupport() {
    }

    public static Converter getConverter(Class<?> k) {
        Converter c = ConverterRegistry.getConverterForClass(k);
        if (c != null) {
            return c;
        }
        PropertyEditor pe = PropertyEditorManager.findEditor(k);
        if (pe != null) {
            return new PropertyEditorConverter(pe);
        }
        return null;
    }

    public static Object[] convertArgs(Object[] args, Class<?>[] argumentTypes) {
        Object[] convertedArgs = new Object[args.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            convertedArgs[i] = ConverterSupport.convertArg(args[i], argumentTypes[i]);
        }
        return convertedArgs;
    }

    private static Object convertArg(Object arg, Class<?> argumentType) throws SlimError {
        if (arg == null || argumentType.isInstance(arg)) {
            return arg;
        }
        Converter converter = ConverterSupport.getConverter(argumentType);
        if (converter != null) {
            return converter.fromString(arg.toString());
        }
        throw new SlimError(String.format("message:<<NO_CONVERTER_FOR_ARGUMENT_NUMBER %s.>>", argumentType.getName()));
    }
}

