/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesseContext;
import fitnesse.updates.Update;
import fitnesse.updates.UpdaterBase;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.junit.After;
import org.junit.Before;
import util.FileUtil;

public abstract class UpdateTestCase {
    public static final String testDir = "testDir";
    public static final String rootName = "RooT";
    protected WikiPage root;
    protected Update update;
    protected UpdaterBase updater;
    protected WikiPage pageOne;
    protected WikiPage pageTwo;
    protected FitNesseContext context;
    protected PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.context = new FitNesseContext();
        this.context.rootPath = testDir;
        this.context.rootDirectoryName = rootName;
        this.context.rootPagePath = "testDir/RooT";
        FileUtil.makeDir(testDir);
        this.root = new FileSystemPage(this.context.rootPath, this.context.rootDirectoryName);
        this.crawler = this.root.getPageCrawler();
        this.context.root = this.root;
        this.pageOne = this.crawler.addPage(this.root, PathParser.parse("PageOne"), "some content");
        this.pageTwo = this.crawler.addPage(this.pageOne, PathParser.parse("PageTwo"), "page two content");
        this.updater = new UpdaterBase(this.context);
        this.update = this.makeUpdate();
    }

    @After
    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory(testDir);
    }

    protected Update makeUpdate() throws Exception {
        return null;
    }
}

