/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;

public class HelpWidget
extends WikiWidget {
    public static final String REGEXP = "!help *(-editable)?";
    private final boolean editable;

    public HelpWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        this.editable = text.contains("-editable");
    }

    @Override
    public String render() throws Exception {
        String helpText = this.getWikiPage().getHelpText();
        String editString = "edit";
        if (helpText == null) {
            helpText = "";
            editString = "edit help text";
        }
        WikiPagePath path = this.getWikiPage().getPageCrawler().getFullPath(this.getWikiPage());
        if (this.editable) {
            helpText = helpText + " <a href=\"" + path.toString() + "?properties\">(" + editString + ")</a>";
        }
        return helpText;
    }
}

