/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;

public class HtmlTableListingBuilder {
    private int shade = 0;
    private HtmlTag table;

    public HtmlTableListingBuilder() {
        this.makeTable();
    }

    public HtmlTag getTable() {
        return this.table;
    }

    private HtmlTag makeTable() {
        this.table = new HtmlTag("table");
        this.table.addAttribute("border", "0");
        this.table.addAttribute("cellspacing", "0");
        this.table.addAttribute("class", "dirListing");
        return this.table;
    }

    public void addRow(HtmlElement[] rowItems) {
        HtmlTag row = new HtmlTag("tr");
        this.addShade(row);
        HtmlTag cell = null;
        for (HtmlElement rowItem : rowItems) {
            cell = new HtmlTag("td", rowItem);
            row.add(cell);
        }
        cell.addAttribute("style", "text-align: right;");
        this.table.add(row);
    }

    private void addShade(HtmlTag row) {
        if (this.shade++ % 2 == 0) {
            row.addAttribute("style", "background-color: #EFEFEF;");
        } else {
            row.addAttribute("style", "background-color: #FFFFFF;");
        }
    }
}

