/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTableListingBuilder;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wikitext.Utils;
import java.util.Set;
import org.json.JSONObject;

public class PropertiesResponder
implements SecureResponder {
    private WikiPage page;
    public PageData pageData;
    private String resource;
    private SimpleResponse response;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.response = new SimpleResponse();
        this.resource = request.getResource();
        WikiPagePath path = PathParser.parse(this.resource);
        PageCrawler crawler = context.root.getPageCrawler();
        if (!crawler.pageExists(context.root, path)) {
            crawler.setDeadEndStrategy(new MockingPageCrawler());
        }
        this.page = crawler.getPage(context.root, path);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.pageData = this.page.getData();
        this.makeContent(context, request);
        this.response.setMaxAge(0);
        return this.response;
    }

    private void makeContent(FitNesseContext context, Request request) throws Exception {
        if ("json".equals(request.getInput("format"))) {
            JSONObject jsonObject = this.makeJson();
            this.response.setContent(jsonObject.toString(1));
        } else {
            String html = this.makeHtml(context);
            this.response.setContent(html);
        }
    }

    private JSONObject makeJson() throws Exception {
        String[] attributes;
        this.response.setContentType("text/json");
        JSONObject jsonObject = new JSONObject();
        for (String attribute : attributes = new String[]{PageType.TEST.toString(), "Search", "Edit", "Properties", "Versions", "Refactor", "WhereUsed", "RecentChanges", PageType.SUITE.toString(), "Prune", "secure-read", "secure-write", "secure-test"}) {
            this.addJsonAttribute(jsonObject, attribute);
        }
        return jsonObject;
    }

    private void addJsonAttribute(JSONObject jsonObject, String attribute) throws Exception {
        jsonObject.put(attribute, this.pageData.hasAttribute(attribute));
    }

    private String makeHtml(FitNesseContext context) throws Exception {
        HtmlPage page = context.htmlPageFactory.newPage();
        page.title.use("Properties: " + this.resource);
        page.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Page Properties"));
        page.main.use(this.makeLastModifiedTag());
        page.main.add(this.makeFormSections());
        return page.html();
    }

    private HtmlTag makeAttributeCheckbox(String attribute, String displayString, PageData pageData) throws Exception {
        HtmlTag checkbox = this.makeCheckbox(attribute, displayString);
        if (pageData.hasAttribute(attribute)) {
            checkbox.addAttribute("checked", "true");
        }
        return checkbox;
    }

    private HtmlTag makeCheckbox(String attribute, String displayString) {
        HtmlTag checkbox = HtmlUtil.makeInputTag("checkbox", attribute);
        checkbox.tail = " - " + displayString;
        return checkbox;
    }

    private HtmlTag makeLastModifiedTag() throws Exception {
        HtmlTag tag = HtmlUtil.makeDivTag("right");
        String username = this.pageData.getAttribute("LastModifyingUser");
        if (username == null || "".equals(username)) {
            tag.use("Last modified anonymously");
        } else {
            tag.use("Last modified by " + username);
        }
        return tag;
    }

    private HtmlTag makeFormSections() throws Exception {
        TagGroup html = new TagGroup();
        html.add(this.makePropertiesForm());
        WikiImportProperty importProperty = WikiImportProperty.createFrom(this.pageData.getProperties());
        if (importProperty != null) {
            html.add(this.makeImportUpdateForm(importProperty));
        } else {
            html.add(this.makeImportForm());
        }
        html.add(this.makeSymbolicLinkSection());
        return html;
    }

    private HtmlTag makePropertiesForm() throws Exception {
        HtmlTag form = HtmlUtil.makeFormTag("post", this.resource);
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "saveProperties"));
        HtmlTag trisection = new HtmlTag("div");
        trisection.addAttribute("style", "width:100%");
        HtmlTag checkBoxesSection = new HtmlTag("div");
        checkBoxesSection.addAttribute("class", "properties");
        checkBoxesSection.add(this.makePageTypeRadiosHtml(this.pageData));
        checkBoxesSection.add(this.makeTestActionCheckboxesHtml(this.pageData));
        checkBoxesSection.add(this.makeNavigationCheckboxesHtml(this.pageData));
        checkBoxesSection.add(this.makeSecurityCheckboxesHtml(this.pageData));
        HtmlTag virtualWikiSection = new HtmlTag("div");
        virtualWikiSection.addAttribute("class", "virtual-wiki-properties");
        virtualWikiSection.add(this.makeVirtualWikiHtml());
        virtualWikiSection.add(this.makeTagsHtml(this.pageData));
        virtualWikiSection.add(this.makeHelpTextHtml(this.pageData));
        trisection.add(checkBoxesSection);
        trisection.add(virtualWikiSection);
        form.add(trisection);
        HtmlTag buttonSection = new HtmlTag("div");
        buttonSection.add(HtmlUtil.BR);
        HtmlTag saveButton = HtmlUtil.makeInputTag("submit", "Save", "Save Properties");
        saveButton.addAttribute("accesskey", "s");
        buttonSection.add(saveButton);
        form.add(buttonSection);
        return form;
    }

    public HtmlTag makePageTypeRadiosHtml(PageData pageData) throws Exception {
        return this.makeAttributeRadiosHtml("Page type: ", PageData.PAGE_TYPE_ATTRIBUTES, "PageType", pageData);
    }

    private HtmlTag makeAttributeRadiosHtml(String label, String[] attributes, String radioGroup, PageData pageData) throws Exception {
        HtmlTag div = new HtmlTag("div");
        div.addAttribute("style", "float: left; width: 150px;");
        div.add(label);
        String checkedAttribute = this.getCheckedAttribute(pageData, attributes);
        for (String attribute : attributes) {
            div.add(HtmlUtil.BR);
            div.add(this.makeAttributeRadio(radioGroup, attribute, attribute.equals(checkedAttribute), attribute));
        }
        div.add(HtmlUtil.BR);
        div.add(HtmlUtil.BR);
        div.add(this.makeAttributeCheckbox("Prune", "Skip (Recursive)", pageData));
        return div;
    }

    private String getCheckedAttribute(PageData pageData, String[] attributes) throws Exception {
        for (int i = attributes.length - 1; i > 0; --i) {
            if (!pageData.hasAttribute(attributes[i])) continue;
            return attributes[i];
        }
        return attributes[0];
    }

    private HtmlTag makeAttributeRadio(String group, String attribute, boolean checked, String guiName) throws Exception {
        HtmlTag radioButton = this.makeRadioButton(group, attribute, guiName);
        if (checked) {
            radioButton.addAttribute("checked", "checked");
        }
        return radioButton;
    }

    private HtmlTag makeRadioButton(String group, String attribute, String guiName) {
        HtmlTag checkbox = HtmlUtil.makeInputTag("radio", group);
        checkbox.addAttribute("value", attribute);
        checkbox.tail = " - " + guiName;
        return checkbox;
    }

    private HtmlTag makeVirtualWikiHtml() throws Exception {
        HtmlTag virtualWiki = new HtmlTag("div");
        virtualWiki.addAttribute("style", "float: left; width: 450px;");
        virtualWiki.add("VirtualWiki URL: ");
        HtmlTag deprecated = new HtmlTag("span", "(DEPRECATED)");
        deprecated.addAttribute("style", "color: #FF0000;");
        virtualWiki.add(deprecated);
        virtualWiki.add(HtmlUtil.BR);
        HtmlTag vwInput = HtmlUtil.makeInputTag("text", "VirtualWiki", PropertiesResponder.getVirtualWikiValue(this.pageData));
        vwInput.addAttribute("size", "40");
        virtualWiki.add(vwInput);
        virtualWiki.add(HtmlUtil.NBSP);
        virtualWiki.add(HtmlUtil.NBSP);
        return virtualWiki;
    }

    private HtmlTag makeImportForm() {
        HtmlTag form = HtmlUtil.makeFormTag("post", this.resource + "#end");
        form.add(HtmlUtil.HR);
        form.add("Wiki Import.  Supply the URL for the wiki you'd like to import.");
        form.add(HtmlUtil.BR);
        form.add("Remote Wiki URL:");
        HtmlTag remoteUrlField = HtmlUtil.makeInputTag("text", "remoteUrl");
        remoteUrlField.addAttribute("size", "70");
        form.add(remoteUrlField);
        form.add(HtmlUtil.BR);
        HtmlTag autoUpdateCheckBox = HtmlUtil.makeInputTag("checkbox", "autoUpdate", "checked");
        autoUpdateCheckBox.addAttribute("checked", "true");
        form.add(autoUpdateCheckBox);
        form.add("- Automatically update imported content when executing tests");
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "import"));
        form.add(HtmlUtil.makeInputTag("submit", "save", "Import"));
        return form;
    }

    private HtmlTag makeImportUpdateForm(WikiImportProperty importProps) throws Exception {
        String buttonMessage;
        HtmlTag form = HtmlUtil.makeFormTag("post", this.resource + "#end");
        form.add(HtmlUtil.HR);
        form.add(new HtmlTag("b", "Wiki Import Update"));
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeLink(this.page.getName(), this.page.getName()));
        if (importProps.isRoot()) {
            form.add(" imports its subpages from ");
            buttonMessage = "Update Subpages";
        } else {
            form.add(" imports its content and subpages from ");
            buttonMessage = "Update Content and Subpages";
        }
        form.add(HtmlUtil.makeLink(importProps.getSourceUrl(), importProps.getSourceUrl()));
        form.add(".");
        form.add(HtmlUtil.BR);
        HtmlTag autoUpdateCheckBox = HtmlUtil.makeInputTag("checkbox", "autoUpdate");
        if (importProps.isAutoUpdate()) {
            autoUpdateCheckBox.addAttribute("checked", "true");
        }
        form.add(autoUpdateCheckBox);
        form.add("- Automatically update imported content when executing tests");
        form.add(HtmlUtil.BR);
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "import"));
        form.add(HtmlUtil.makeInputTag("submit", "save", buttonMessage));
        return form;
    }

    private HtmlTag makeSymbolicLinkSection() throws Exception {
        HtmlTag form = HtmlUtil.makeFormTag("get", this.resource, "symbolics");
        form.add(HtmlUtil.HR);
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "symlink"));
        form.add(new HtmlTag("strong", "Symbolic Links"));
        HtmlTableListingBuilder table = new HtmlTableListingBuilder();
        table.getTable().addAttribute("style", "width:80%");
        table.addRow(new HtmlElement[]{new HtmlTag("strong", "Name"), new HtmlTag("strong", "Path to Page"), new HtmlTag("strong", "Actions")});
        this.addSymbolicLinkRows(table);
        this.addFormRow(table);
        form.add(table.getTable());
        return form;
    }

    private void addFormRow(HtmlTableListingBuilder table) throws Exception {
        HtmlTag nameInput = HtmlUtil.makeInputTag("text", "linkName");
        nameInput.addAttribute("size", "16%");
        HtmlTag pathInput = HtmlUtil.makeInputTag("text", "linkPath");
        pathInput.addAttribute("size", "60%");
        HtmlTag submitButton = HtmlUtil.makeInputTag("submit", "submit", "Create/Replace");
        submitButton.addAttribute("style", "width:8em");
        table.addRow(new HtmlElement[]{nameInput, pathInput, submitButton});
    }

    private void addSymbolicLinkRows(HtmlTableListingBuilder table) throws Exception {
        WikiPageProperty symLinksProperty = this.pageData.getProperties().getProperty("SymbolicLinks");
        if (symLinksProperty == null) {
            return;
        }
        Set<String> symbolicLinkNames = symLinksProperty.keySet();
        for (String linkName : symbolicLinkNames) {
            RawHtml nameItem = new RawHtml(linkName);
            HtmlElement pathItem = this.makeHtmlForSymbolicPath(symLinksProperty, linkName);
            HtmlTag actionItems = HtmlUtil.makeLink(this.resource + "?responder=symlink&removal=" + linkName, "Unlink&nbsp;");
            String callScript = "javascript:symbolicLinkRename('" + linkName + "','" + this.resource + "');";
            actionItems.tail = HtmlUtil.makeLink(callScript, "&nbsp;Rename:").html();
            HtmlTag newNameInput = HtmlUtil.makeInputTag("text", linkName);
            newNameInput.addAttribute("size", "16%");
            table.addRow(new HtmlElement[]{nameItem, pathItem, actionItems, newNameInput});
        }
    }

    private HtmlElement makeHtmlForSymbolicPath(WikiPageProperty symLinksProperty, String linkName) throws Exception {
        String linkPath = symLinksProperty.get(linkName);
        WikiPagePath wikiPagePath = PathParser.parse(linkPath);
        if (wikiPagePath != null) {
            WikiPagePath fullPath;
            WikiPage parent = wikiPagePath.isRelativePath() ? this.page.getParent() : this.page;
            PageCrawler crawler = parent.getPageCrawler();
            WikiPage target = crawler.getPage(parent, wikiPagePath);
            if (target != null) {
                fullPath = crawler.getFullPath(target);
                fullPath.makeAbsolute();
            } else {
                fullPath = new WikiPagePath();
            }
            return HtmlUtil.makeLink(fullPath.toString(), Utils.escapeHTML(linkPath));
        }
        return new RawHtml(linkPath);
    }

    public static String getVirtualWikiValue(PageData data) throws Exception {
        String value = data.getAttribute("VirtualWiki");
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    public HtmlTag makeTestActionCheckboxesHtml(PageData pageData) throws Exception {
        return this.makeAttributeCheckboxesHtml("Actions:", PageData.ACTION_ATTRIBUTES, pageData);
    }

    public HtmlElement makeNavigationCheckboxesHtml(PageData pageData) throws Exception {
        return this.makeAttributeCheckboxesHtml("Navigation:", PageData.NAVIGATION_ATTRIBUTES, pageData);
    }

    public HtmlTag makeSecurityCheckboxesHtml(PageData pageData) throws Exception {
        return this.makeAttributeCheckboxesHtml("Security:", PageData.SECURITY_ATTRIBUTES, pageData);
    }

    public HtmlTag makeTagsHtml(PageData pageData) throws Exception {
        HtmlTag div = new HtmlTag("div");
        div.addAttribute("style", "float: left; padding-right: 5px");
        div.add(this.makeInputField("Tags:", "Suites", "Suites", 40, pageData));
        return div;
    }

    public HtmlTag makeHelpTextHtml(PageData pageData) throws Exception {
        return this.makeInputField("Help Text:", "Help", "HelpText", 90, pageData);
    }

    public HtmlTag makeInputField(String label, String propertyName, String fieldId, int size, PageData pageData) throws Exception {
        String propValue;
        HtmlTag div = new HtmlTag("div");
        div.addAttribute("style", "float: left;");
        div.add(label);
        String textValue = "";
        WikiPageProperty theProp = pageData.getProperties().getProperty(propertyName);
        if (theProp != null && (propValue = theProp.getValue()) != null) {
            textValue = propValue;
        }
        div.add(HtmlUtil.BR);
        HtmlTag input = HtmlUtil.makeInputTag("text", fieldId, textValue);
        input.addAttribute("size", Integer.toString(size));
        div.add(input);
        return div;
    }

    private HtmlTag makeAttributeCheckboxesHtml(String label, String[] attributes, PageData pageData) throws Exception {
        HtmlTag div = new HtmlTag("div");
        div.addAttribute("style", "float: left; width: 180px;");
        div.add(label);
        for (String attribute : attributes) {
            div.add(HtmlUtil.BR);
            div.add(this.makeAttributeCheckbox(attribute, attribute, pageData));
        }
        div.add(HtmlUtil.BR);
        div.add(HtmlUtil.BR);
        return div;
    }
}

