/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Jsr223Bridge;
import fitnesse.slim.Jsr223SlimFactory;
import fitnesse.slim.StatementExecutorTestBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class Jsr223StatementExecutorTestBase
extends StatementExecutorTestBase {
    protected static Jsr223SlimFactory slimFactory;
    protected static Jsr223Bridge bridge;

    @AfterClass
    public static void tearDownClass() {
        slimFactory.stop();
    }

    @Override
    @Before
    public void init() throws Exception {
        this.statementExecutor = slimFactory.getStatementExecutor();
        this.statementExecutor.addPath(this.getTestModulePath());
    }

    protected abstract String getTestModulePath();

    @Override
    protected StatementExecutorTestBase.Echo getVerifiedInstance() {
        FixtureProxyJsr223 myInstance = new FixtureProxyJsr223(this.statementExecutor.getInstance("myInstance"));
        Assert.assertFalse((boolean)myInstance.echoCalled());
        return myInstance;
    }

    @Override
    protected void createFixtureInstance(String fixtureClass) {
        Object created = this.statementExecutor.create("myInstance", fixtureClass, new Object[0]);
        Assert.assertEquals((Object)"OK", (Object)created);
    }

    @Override
    protected StatementExecutorTestBase.MyAnnotatedSystemUnderTestFixture createAnnotatedFixture() {
        this.createFixtureInstance(this.annotatedFixtureName());
        return new MyAnnotatedSystemUnderTestFixtureJsr223((FixtureProxyJsr223)this.getVerifiedInstance());
    }

    @Override
    protected StatementExecutorTestBase.FixtureWithNamedSystemUnderTestBase createNamedFixture() {
        this.createFixtureInstance(this.namedFixtureName());
        return new FixtureWithNamedSystemUnderTestJsr223((FixtureProxyJsr223)this.getVerifiedInstance());
    }

    @Override
    protected StatementExecutorTestBase.SimpleFixture createSimpleFixture() {
        this.createFixtureInstance(this.simpleFixtureName());
        return new SimpleFixtureJsr223((FixtureProxyJsr223)this.getVerifiedInstance());
    }

    @Override
    protected StatementExecutorTestBase.EchoSupport createEchoLibrary() {
        String instanceName = "library" + this.library++;
        Object created = this.statementExecutor.create(instanceName, this.echoLibraryName(), new Object[0]);
        Assert.assertEquals((Object)"OK", (Object)created);
        return new EchoSupportJsr223(new FixtureProxyJsr223(this.statementExecutor.getInstance(instanceName)));
    }

    @Override
    protected StatementExecutorTestBase.FileSupport createFileSupportLibrary() {
        String instanceName = "library" + this.library++;
        Object created = this.statementExecutor.create(instanceName, this.fileSupportName(), new Object[0]);
        Assert.assertEquals((Object)"OK", (Object)created);
        return new FileSupportJsr223(new FixtureProxyJsr223(this.statementExecutor.getInstance(instanceName)));
    }

    @Override
    protected String annotatedFixtureName() {
        return "MyAnnotatedSystemUnderTestFixture";
    }

    @Override
    protected String namedFixtureName() {
        return "FixtureWithNamedSystemUnderTest";
    }

    @Override
    protected String echoLibraryName() {
        return "EchoSupport";
    }

    @Override
    protected String fileSupportName() {
        return "FileSupport";
    }

    @Override
    protected String simpleFixtureName() {
        return "SimpleFixture";
    }

    public static class FixtureProxyJsr223
    implements StatementExecutorTestBase.Echo,
    StatementExecutorTestBase.Speak,
    StatementExecutorTestBase.Delete,
    StatementExecutorTestBase.SystemUnderTestFixture {
        private Object proxy;

        public FixtureProxyJsr223(Object instance) {
            this.proxy = instance;
        }

        @Override
        public void echo() {
        }

        @Override
        public boolean echoCalled() {
            return (Boolean)this.callMethod("echoCalled", new Object[0]);
        }

        @Override
        public void speak() {
        }

        @Override
        public boolean speakCalled() {
            return (Boolean)this.callMethod("speakCalled", new Object[0]);
        }

        @Override
        public void delete(String fileName) {
        }

        @Override
        public boolean deleteCalled() {
            return (Boolean)this.callMethod("deleteCalled", new Object[0]);
        }

        @Override
        public StatementExecutorTestBase.MySystemUnderTestBase getSystemUnderTest() {
            return new MySystemUnderTestJsr223(new FixtureProxyJsr223(this.callMethod("getSystemUnderTest", new Object[0])));
        }

        private Object callMethod(String method, Object ... args) {
            try {
                return bridge.invokeMethod(this.proxy, method, args);
            }
            catch (Throwable e) {
                return e.toString();
            }
        }
    }

    public static class MyAnnotatedSystemUnderTestFixtureJsr223
    extends StatementExecutorTestBase.MyAnnotatedSystemUnderTestFixture {
        private FixtureProxyJsr223 fixtureProxy;

        public MyAnnotatedSystemUnderTestFixtureJsr223(FixtureProxyJsr223 fixtureProxy) {
            this.fixtureProxy = fixtureProxy;
        }

        @Override
        public void echo() {
            this.fixtureProxy.echo();
        }

        @Override
        public boolean echoCalled() {
            return this.fixtureProxy.echoCalled();
        }

        @Override
        public StatementExecutorTestBase.MySystemUnderTestBase getSystemUnderTest() {
            return this.fixtureProxy.getSystemUnderTest();
        }
    }

    public static class MySystemUnderTestJsr223
    extends StatementExecutorTestBase.MySystemUnderTestBase {
        private FixtureProxyJsr223 fixtureProxy;

        public MySystemUnderTestJsr223(FixtureProxyJsr223 fixtureProxy) {
            this.fixtureProxy = fixtureProxy;
        }

        @Override
        public void echo() {
            this.fixtureProxy.echo();
        }

        @Override
        public boolean echoCalled() {
            return this.fixtureProxy.echoCalled();
        }

        @Override
        public void speak() {
            this.fixtureProxy.speak();
        }

        @Override
        public boolean speakCalled() {
            return this.fixtureProxy.speakCalled();
        }
    }

    public static class FixtureWithNamedSystemUnderTestJsr223
    extends StatementExecutorTestBase.FixtureWithNamedSystemUnderTestBase {
        private FixtureProxyJsr223 fixtureProxy;

        public FixtureWithNamedSystemUnderTestJsr223(FixtureProxyJsr223 fixtureProxy) {
            this.fixtureProxy = fixtureProxy;
        }

        @Override
        public void echo() {
            this.fixtureProxy.echo();
        }

        @Override
        public boolean echoCalled() {
            return this.fixtureProxy.echoCalled();
        }

        @Override
        public StatementExecutorTestBase.MySystemUnderTestBase getSystemUnderTest() {
            return this.fixtureProxy.getSystemUnderTest();
        }
    }

    public static class SimpleFixtureJsr223
    extends StatementExecutorTestBase.SimpleFixture {
        private FixtureProxyJsr223 fixtureProxy;

        public SimpleFixtureJsr223(FixtureProxyJsr223 fixtureProxy) {
            this.fixtureProxy = fixtureProxy;
        }

        @Override
        public void echo() {
            this.fixtureProxy.echo();
        }

        @Override
        public boolean echoCalled() {
            return this.fixtureProxy.echoCalled();
        }
    }

    public static class EchoSupportJsr223
    extends StatementExecutorTestBase.EchoSupport {
        private FixtureProxyJsr223 fixtureProxy;

        public EchoSupportJsr223(FixtureProxyJsr223 fixtureProxy) {
            this.fixtureProxy = fixtureProxy;
        }

        @Override
        public void echo() {
            this.fixtureProxy.echo();
        }

        @Override
        public boolean echoCalled() {
            return this.fixtureProxy.echoCalled();
        }

        @Override
        public void speak() {
            this.fixtureProxy.speak();
        }

        @Override
        public boolean speakCalled() {
            return this.fixtureProxy.speakCalled();
        }
    }

    public static class FileSupportJsr223
    extends StatementExecutorTestBase.FileSupport {
        private FixtureProxyJsr223 fixtureProxy;

        public FileSupportJsr223(FixtureProxyJsr223 fixtureProxy) {
            this.fixtureProxy = fixtureProxy;
        }

        @Override
        public void delete(String fileName) {
            this.fixtureProxy.delete(fileName);
        }

        @Override
        public boolean deleteCalled() {
            return this.fixtureProxy.deleteCalled();
        }
    }
}

