/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.ComponentFactory;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageRepository;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.VersionsController;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.zip.ZipFileVersionsController;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.Date;
import util.Clock;
import util.DiskFileSystem;
import util.FileSystem;
import util.FileUtil;

public class FileSystemPage
extends CachingPage {
    private static final long serialVersionUID = 1L;
    public static final String contentFilename = "/content.txt";
    public static final String propertiesFilename = "/properties.xml";
    private final String path;
    private final VersionsController versionsController;
    private CmSystem cmSystem = new CmSystem();

    public FileSystemPage(String path, String name, FileSystem fileSystem, ComponentFactory componentFactory) throws Exception {
        super(name, null);
        this.path = path;
        this.versionsController = this.createVersionsController(componentFactory);
        this.createDirectoryIfNewPage(fileSystem);
    }

    public FileSystemPage(String path, String name) throws Exception {
        this(path, name, new DiskFileSystem(), new ComponentFactory());
    }

    public FileSystemPage(String name, FileSystemPage parent, FileSystem fileSystem) throws Exception {
        super(name, parent);
        this.path = parent.getFileSystemPath();
        this.versionsController = parent.versionsController;
        this.createDirectoryIfNewPage(fileSystem);
    }

    private VersionsController createVersionsController(ComponentFactory factory) throws Exception {
        return (VersionsController)factory.createComponent("VersionsController", ZipFileVersionsController.class);
    }

    @Override
    public void removeChildPage(String name) throws Exception {
        super.removeChildPage(name);
        String pathToDelete = this.getFileSystemPath() + "/" + name;
        File fileToBeDeleted = new File(pathToDelete);
        this.cmSystem.preDelete(pathToDelete);
        FileUtil.deleteFileSystemDirectory(fileToBeDeleted);
        this.cmSystem.delete(pathToDelete);
    }

    @Override
    public boolean hasChildPage(String pageName) throws Exception {
        File f = new File(this.getFileSystemPath() + "/" + pageName);
        if (f.exists()) {
            this.addChildPage(pageName);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveContent(String content) throws Exception {
        if (content == null) {
            return;
        }
        String separator = System.getProperty("line.separator");
        if (content.endsWith("|")) {
            content = content + separator;
        }
        content = content.replaceAll("\r\n", "\n");
        content = content.replaceAll("\n", separator);
        String contentPath = this.getFileSystemPath() + contentFilename;
        File output = new File(contentPath);
        OutputStreamWriter writer = null;
        try {
            if (output.exists()) {
                this.cmSystem.edit(contentPath);
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8");
            writer.write(content);
        }
        finally {
            if (writer != null) {
                writer.close();
                this.cmSystem.update(contentPath);
            }
        }
    }

    protected synchronized void saveAttributes(WikiPageProperties attributes) throws Exception {
        OutputStream output = null;
        String propertiesFilePath = "<unknown>";
        try {
            propertiesFilePath = this.getFileSystemPath() + propertiesFilename;
            File propertiesFile = new File(propertiesFilePath);
            if (propertiesFile.exists()) {
                this.cmSystem.edit(propertiesFilePath);
            }
            output = new FileOutputStream(propertiesFile);
            WikiPageProperties propertiesToSave = new WikiPageProperties(attributes);
            this.removeAlwaysChangingProperties(propertiesToSave);
            propertiesToSave.save(output);
        }
        catch (Exception e) {
            System.err.println("Failed to save properties file: \"" + propertiesFilePath + "\" (exception: " + e + ").");
            e.printStackTrace();
            throw e;
        }
        finally {
            if (output != null) {
                output.close();
                this.cmSystem.update(propertiesFilePath);
            }
        }
    }

    private void removeAlwaysChangingProperties(WikiPageProperties properties) {
        properties.remove("LastModified");
    }

    @Override
    protected WikiPage createChildPage(String name) throws Exception {
        return new PageRepository().makeChildPage(name, this);
    }

    private void loadContent(PageData data) throws Exception {
        String content = "";
        String name = this.getFileSystemPath() + contentFilename;
        File input = new File(name);
        if (input.exists()) {
            byte[] bytes = this.readContentBytes(input);
            content = new String(bytes, "UTF-8");
        }
        data.setContent(content);
    }

    @Override
    protected void loadChildren() throws Exception {
        File thisDir = new File(this.getFileSystemPath());
        if (thisDir.exists()) {
            String[] subFiles;
            for (String subFile : subFiles = thisDir.list()) {
                if (!this.fileIsValid(subFile, thisDir) || this.children.containsKey(subFile)) continue;
                this.children.put(subFile, this.getChildPage(subFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readContentBytes(File input) throws IOException {
        FileInputStream inputStream = null;
        try {
            byte[] bytes = new byte[(int)input.length()];
            inputStream = new FileInputStream(input);
            inputStream.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private boolean fileIsValid(String filename, File dir) {
        File f;
        return WikiWordWidget.isWikiWord(filename) && (f = new File(dir, filename)).isDirectory();
    }

    private String getParentFileSystemPath() {
        return this.parent != null ? ((FileSystemPage)this.parent).getFileSystemPath() : this.path;
    }

    public String getFileSystemPath() {
        return this.getParentFileSystemPath() + "/" + this.getName();
    }

    public String getAbsoluteFileSystemPath() {
        return new File(this.getFileSystemPath()).getAbsolutePath();
    }

    private void loadAttributes(PageData data) throws Exception {
        File file = new File(this.getFileSystemPath() + propertiesFilename);
        if (file.exists()) {
            try {
                long lastModifiedTime = this.getLastModifiedTime();
                this.attemptToReadPropertiesFile(file, data, lastModifiedTime);
            }
            catch (Exception e) {
                System.err.println("Could not read properties file:" + file.getPath());
                e.printStackTrace();
            }
        }
    }

    private long getLastModifiedTime() throws Exception {
        long lastModifiedTime = 0L;
        File file = new File(this.getFileSystemPath() + contentFilename);
        lastModifiedTime = file.exists() ? file.lastModified() : Clock.currentTimeInMillis();
        return lastModifiedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToReadPropertiesFile(File file, PageData data, long lastModifiedTime) throws Exception {
        InputStream input = null;
        try {
            WikiPageProperties props = new WikiPageProperties();
            input = new FileInputStream(file);
            props.loadFromXmlStream(input);
            props.setLastModificationTime(new Date(lastModifiedTime));
            data.setProperties(props);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    @Override
    public void doCommit(PageData data) throws Exception {
        this.saveContent(data.getContent());
        this.saveAttributes(data.getProperties());
        this.versionsController.prune(this);
    }

    @Override
    protected PageData makePageData() throws Exception {
        PageData pagedata = new PageData(this);
        this.loadContent(pagedata);
        this.loadAttributes(pagedata);
        pagedata.addVersions(this.versionsController.history(this));
        return pagedata;
    }

    @Override
    public PageData getDataVersion(String versionName) throws Exception {
        return this.versionsController.getRevisionData(this, versionName);
    }

    private void createDirectoryIfNewPage(FileSystem fileSystem) throws Exception {
        String pagePath = this.getFileSystemPath();
        if (!fileSystem.exists(pagePath)) {
            fileSystem.makeDirectory(pagePath);
            this.cmSystem.update(pagePath);
        }
    }

    @Override
    protected VersionInfo makeVersion() throws Exception {
        PageData data = this.getData();
        return this.makeVersion(data);
    }

    protected VersionInfo makeVersion(PageData data) throws Exception {
        return this.versionsController.makeVersion(this, data);
    }

    protected void removeVersion(String versionName) throws Exception {
        this.versionsController.removeVersion(this, versionName);
    }

    @Override
    public String toString() {
        try {
            return this.getClass().getName() + " at " + this.getFileSystemPath();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    class CmSystem {
        CmSystem() {
        }

        public void update(String fileName) throws Exception {
            this.invokeCmMethod("cmUpdate", fileName);
        }

        public void edit(String fileName) throws Exception {
            this.invokeCmMethod("cmEdit", fileName);
        }

        public void delete(String fileToBeDeleted) throws Exception {
            this.invokeCmMethod("cmDelete", fileToBeDeleted);
        }

        public void preDelete(String fileToBeDeleted) throws Exception {
            this.invokeCmMethod("cmPreDelete", fileToBeDeleted);
        }

        private void invokeCmMethod(String method, String newPagePath) throws Exception {
            if (this.getCmSystemClassName() != null) {
                try {
                    Class<?> cmSystem = Class.forName(this.getCmSystemClassName());
                    Method updateMethod = cmSystem.getMethod(method, String.class, String.class);
                    updateMethod.invoke(null, newPagePath, this.getCmSystemVariable());
                }
                catch (Exception e) {
                    System.err.println("Could not invoke static " + method + "(path,payload) of " + this.getCmSystemClassName());
                    e.printStackTrace();
                }
            }
        }

        private String getCmSystemClassName() throws Exception {
            String cmSystemVariable = this.getCmSystemVariable();
            if (cmSystemVariable == null) {
                return null;
            }
            String cmSystemClassName = cmSystemVariable.split(" ")[0].trim();
            if (cmSystemClassName == null || cmSystemClassName.equals("")) {
                return null;
            }
            return cmSystemClassName;
        }

        private String getCmSystemVariable() throws Exception {
            return FileSystemPage.this.getData().getVariable("CM_SYSTEM");
        }
    }
}

