/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.http.ResponseParser;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import util.Clock;

public class ProxyPage
extends CachingPage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static int retrievalCount = 0;
    private String host;
    private int hostPort;
    private WikiPagePath realPath;
    public ResponseParser parser;
    private long lastLoadChildrenTime = 0L;

    public ProxyPage(WikiPage original) throws Exception {
        super(original.getName(), null);
        this.realPath = original.getPageCrawler().getFullPath(original);
        List<WikiPage> children = original.getChildren();
        Iterator<WikiPage> iterator = children.iterator();
        while (iterator.hasNext()) {
            ProxyPage child = new ProxyPage(iterator.next());
            child.parent = this;
            this.children.put(child.getName(), child);
        }
    }

    protected ProxyPage(String name, WikiPage parent) throws Exception {
        super(name, parent);
    }

    public ProxyPage(String name, WikiPage parent, String host, int port, WikiPagePath path) throws Exception {
        super(name, parent);
        this.host = host;
        this.hostPort = port;
        this.realPath = path;
    }

    public static ProxyPage retrievePage(String urlString) throws Exception {
        ++retrievalCount;
        URL url = new URL(urlString + "?responder=proxy&type=bones");
        ProxyPage page = (ProxyPage)ProxyPage.getObjectFromUrl(url);
        page.setTransientValues(url.getHost(), Clock.currentTimeInMillis());
        int port = url.getPort();
        page.setHostPort(port == -1 ? 80 : port);
        page.lastLoadChildrenTime = Clock.currentTimeInMillis();
        return page;
    }

    @Override
    protected WikiPage createChildPage(String name) throws Exception {
        WikiPagePath childPath = this.realPath.copy().addNameToEnd(name);
        return new ProxyPage(name, this, this.host, this.getHostPort(), childPath);
    }

    @Override
    protected void loadChildren() throws Exception {
        if ((long)cacheTime <= Clock.currentTimeInMillis() - this.lastLoadChildrenTime) {
            ProxyPage page = ProxyPage.retrievePage(this.getThisPageUrl());
            this.children.clear();
            for (ProxyPage child : page.children.values()) {
                child.parent = this;
                this.children.put(child.getName(), child);
            }
            this.lastLoadChildrenTime = Clock.currentTimeInMillis();
        }
    }

    public String getThisPageUrl() {
        StringBuffer url = new StringBuffer("http://");
        url.append(this.host);
        url.append(":").append(this.getHostPort());
        url.append("/").append(PathParser.render(this.realPath));
        return url.toString();
    }

    @Override
    public boolean hasChildPage(String pageName) throws Exception {
        if (this.children.containsKey(pageName)) {
            return true;
        }
        this.loadChildren();
        return this.children.containsKey(pageName);
    }

    public void setTransientValues(String host, long lastLoadTime) {
        this.host = host;
        this.lastLoadChildrenTime = lastLoadTime;
        for (ProxyPage page : this.children.values()) {
            page.setTransientValues(host, lastLoadTime);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHostPort(int port) {
        this.hostPort = port;
        for (ProxyPage page : this.children.values()) {
            page.setHostPort(port);
        }
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public PageData getMeat() throws Exception {
        return this.getMeat(null);
    }

    public PageData getMeat(String versionName) throws Exception {
        URL url;
        PageData data;
        StringBuffer urlString = new StringBuffer(this.getThisPageUrl());
        urlString.append("?responder=proxy&type=meat");
        if (versionName != null) {
            urlString.append("&version=").append(versionName);
        }
        if ((data = (PageData)ProxyPage.getObjectFromUrl(url = new URL(urlString.toString()))) != null) {
            data.setWikiPage(this);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getObjectFromUrl(URL url) throws Exception {
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            Object obj;
            is = url.openStream();
            ois = new ObjectInputStream(is);
            Object object = obj = ois.readObject();
            return object;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (ois != null) {
                ois.close();
            }
        }
    }

    @Override
    protected PageData makePageData() throws Exception {
        return this.getMeat();
    }

    @Override
    public PageData getDataVersion(String versionName) throws Exception {
        PageData data = this.getMeat(versionName);
        if (data == null) {
            throw new NoSuchVersionException("There is no version '" + versionName + "'");
        }
        return data;
    }

    @Override
    protected VersionInfo makeVersion() throws Exception {
        return null;
    }

    @Override
    protected void doCommit(PageData data) throws Exception {
    }
}

