/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlText;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.WikiWordBuilder;
import util.GracefulNamer;

public class WikiWord
extends SymbolType
implements Translation {
    public static WikiWord symbolType = new WikiWord(null);
    private SourcePage sourcePage;

    public WikiWord(SourcePage sourcePage) {
        super("WikiWord");
        this.htmlTranslation(this);
        this.sourcePage = sourcePage;
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        return this.buildLink(this.sourcePage, symbol.getContent(), new HtmlText(this.formatWikiWord(symbol.getContent(), symbol)).html());
    }

    private String buildLink(SourcePage currentPage, String pagePath, String linkBody) {
        return new WikiWordBuilder(currentPage, pagePath, linkBody).buildLink("", pagePath);
    }

    private String formatWikiWord(String originalName, Symbol symbol) {
        String regraceOption = symbol.getVariable("REGRACE_LINK", "");
        return regraceOption.equals("true") ? GracefulNamer.regrace(originalName) : originalName;
    }
}

