/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.widgets.BlankParentWidget;
import fitnesse.wikitext.widgets.LinkWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AliasLinkWidget
extends ParentWidget {
    public static final String REGEXP = "\\[\\[[^\n\r\\]]+\\]\\[[^\n\r\\]]+\\]\\]";
    public static final Pattern pattern = Pattern.compile("\\[\\[([^\n\r\\]]+)\\]\\[([^\n\r\\]]+)\\]\\]");
    private String tag;
    private String href;
    WikiPage parentPage = this.getWikiPage().getParent();
    private static final Pattern URL_SUFFIX_PARSER = Pattern.compile("([^\\?\\#]*)((\\?.+)?(\\#.+)?)?");

    public AliasLinkWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        match.find();
        this.tag = match.group(1);
        this.href = match.group(2).trim();
        this.addChildWidgets(this.tag);
    }

    @Override
    public String render() throws Exception {
        String expandedHref = this.expandVariables(this.href);
        Matcher suffixMatcher = URL_SUFFIX_PARSER.matcher(expandedHref);
        suffixMatcher.find();
        String url = suffixMatcher.group(1);
        String urlSuffix = suffixMatcher.group(2);
        return this.makeLinkTag(url, urlSuffix);
    }

    private String makeLinkTag(String url, String urlSuffix) throws Exception {
        if (WikiWordWidget.isWikiWord(url)) {
            return this.makeLinkTagForWikiWord(url, urlSuffix);
        }
        url = LinkWidget.makeUrlUsable(url);
        return String.format("<a href=\"%s\">%s</a>", url + urlSuffix, this.childHtml());
    }

    private String makeLinkTagForWikiWord(String url, String urlSuffix) throws Exception {
        WikiWordWidget www = new WikiWordWidget(new BlankParentWidget((ParentWidget)this, ""), url);
        String theWord = www.getWikiWord();
        WikiPagePath wikiWordPath = PathParser.parse(theWord);
        WikiPagePath fullPathOfWikiWord = this.parentPage.getPageCrawler().getFullPathOfChild(this.parentPage, wikiWordPath);
        String qualifiedName = PathParser.render(fullPathOfWikiWord);
        WikiPage target = this.parentPage.getPageCrawler().getPage(this.parentPage, PathParser.parse(theWord));
        if (target != null) {
            HtmlTag link = HtmlUtil.makeLink(qualifiedName + urlSuffix, this.childHtml());
            this.addHelpText(link, target);
            return link.htmlInline();
        }
        if (this.getWikiPage() instanceof ProxyPage) {
            return this.makeAliasLinkToNonExistentRemotePage(theWord);
        }
        return this.childHtml() + "<a title=\"create page\" href=\"" + qualifiedName + "?edit&amp;nonExistent=true\">[?]</a>";
    }

    private void addHelpText(HtmlTag link, WikiPage wikiPage) throws Exception {
        String helpText = wikiPage.getHelpText();
        if (helpText != null) {
            link.addAttribute("title", helpText);
        }
    }

    private String makeAliasLinkToNonExistentRemotePage(String theWord) throws Exception {
        ProxyPage proxy = (ProxyPage)this.getWikiPage();
        String remoteURLOfPage = proxy.getThisPageUrl();
        String nameOfThisPage = proxy.getName();
        int startOfThisPageName = remoteURLOfPage.lastIndexOf(nameOfThisPage);
        String remoteURLOfParent = remoteURLOfPage.substring(0, startOfThisPageName);
        return this.childHtml() + "<a title=\"create page\" href=\"" + remoteURLOfParent + theWord + "?edit&amp;nonExistent=true\"" + " target=\"" + theWord + "\"" + ">[?]</a>";
    }

    @Override
    public String asWikiText() throws Exception {
        return "[[" + this.childWikiText() + "][" + this.href + "]]";
    }

    @Override
    public void acceptVisitor(WidgetVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public void renamePageIfReferenced(WikiPage pageToRename, String newName) throws Exception {
        if (WikiWordWidget.isWikiWord(this.href)) {
            WikiWordWidget www = new WikiWordWidget(new BlankParentWidget((ParentWidget)this, ""), this.href);
            www.renamePageIfReferenced(pageToRename, newName);
            this.href = www.getText();
        }
    }
}

