/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ngds;

import java.io.ByteArrayOutputStream;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.ngds.ParameterBufferBase;

public class BlobParameterBufferImp
extends ParameterBufferBase
implements BlobParameterBuffer {
    public void addArgument(int argumentType, int value) {
        if (value > 65535) {
            throw new RuntimeException("Blob parameter buffer value out of range for type " + argumentType);
        }
        this.getArgumentsList().add(new ParameterBufferBase.NumericArgument(argumentType, value){

            protected void writeValue(ByteArrayOutputStream outputStream, int value) {
                outputStream.write(2);
                outputStream.write(value);
                outputStream.write(value >> 8);
            }
        });
    }

    byte[] getBytesForNativeCode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(1);
        super.writeArgumentsTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

