/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.layout;

import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.layout.AbsoluteLayout;
import org.netbeans.modules.visual.layout.CardLayout;
import org.netbeans.modules.visual.layout.DevolveWidgetLayout;
import org.netbeans.modules.visual.layout.FlowLayout;
import org.netbeans.modules.visual.layout.OverlayLayout;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutFactory {
    private static final AbsoluteLayout LAYOUT_ABSOLUTE = new AbsoluteLayout();
    private static final OverlayLayout LAYOUT_OVERLAY = new OverlayLayout();

    private LayoutFactory() {
    }

    public static Layout createAbsoluteLayout() {
        return LAYOUT_ABSOLUTE;
    }

    public static Layout createVerticalLayout() {
        GeomUtil.LOG.warning("LayoutFactory.createVerticalLayout() method is deprecated. Use LayoutFactory.createVerticalFlowLayout() method instead.");
        return LayoutFactory.createVerticalFlowLayout(null, 0);
    }

    public static Layout createVerticalLayout(SerialAlignment alignment, int gap) {
        GeomUtil.LOG.warning("LayoutFactory.createVerticalLayout(alignment,gap) method is deprecated. Use LayoutFactory.createVerticalFlowLayout(alignment,gap) method instead.");
        return new FlowLayout(true, alignment != null ? alignment : SerialAlignment.JUSTIFY, gap);
    }

    public static Layout createVerticalFlowLayout() {
        return LayoutFactory.createVerticalFlowLayout(null, 0);
    }

    public static Layout createVerticalFlowLayout(SerialAlignment alignment, int gap) {
        return new FlowLayout(true, alignment != null ? alignment : SerialAlignment.JUSTIFY, gap);
    }

    public static Layout createHorizontalLayout() {
        GeomUtil.LOG.warning("LayoutFactory.createHorizontalLayout() method is deprecated. Use LayoutFactory.createHorizontalFlowLayout() method instead.");
        return LayoutFactory.createHorizontalFlowLayout(null, 0);
    }

    public static Layout createHorizontalLayout(SerialAlignment alignment, int gap) {
        GeomUtil.LOG.warning("LayoutFactory.createHorizontalLayout(alignment,gap) method is deprecated. Use LayoutFactory.createHorizontalFlowLayout(alignment,gap) method instead.");
        return new FlowLayout(false, alignment != null ? alignment : SerialAlignment.JUSTIFY, gap);
    }

    public static Layout createHorizontalFlowLayout() {
        return LayoutFactory.createHorizontalFlowLayout(null, 0);
    }

    public static Layout createHorizontalFlowLayout(SerialAlignment alignment, int gap) {
        return new FlowLayout(false, alignment != null ? alignment : SerialAlignment.JUSTIFY, gap);
    }

    public static Layout createCardLayout(Widget cardLayoutWidget) {
        assert (cardLayoutWidget != null);
        return new CardLayout(cardLayoutWidget);
    }

    public static Widget getActiveCard(Widget cardLayoutWidget) {
        Layout layout = cardLayoutWidget.getLayout();
        return layout instanceof CardLayout ? ((CardLayout)layout).getActiveChildWidget() : null;
    }

    public static void setActiveCard(Widget widget, Widget activeChildWidget) {
        Layout layout = widget.getLayout();
        if (layout instanceof CardLayout) {
            ((CardLayout)layout).setActiveChildWidget(activeChildWidget);
        }
    }

    public static Layout createFillLayout() {
        GeomUtil.LOG.warning("LayoutFactory.createFillLayout() method is deprecated. Use LayoutFactory.createOverlayLayout() method instead.");
        return LayoutFactory.createOverlayLayout();
    }

    public static Layout createOverlayLayout() {
        return LAYOUT_OVERLAY;
    }

    public static SceneLayout createDevolveWidgetLayout(Widget widget, Layout devolveLayout, boolean animate) {
        return new DevolveWidgetLayout(widget, devolveLayout, animate);
    }

    public static <N, E> SceneLayout createSceneGraphLayout(final GraphScene<N, E> graphScene, final GraphLayout<N, E> graphLayout) {
        assert (graphScene != null && graphLayout != null);
        return new SceneLayout(graphScene){

            protected void performLayout() {
                graphLayout.layoutGraph(graphScene);
            }
        };
    }

    public static <N, E> SceneLayout createSceneGraphLayout(final GraphPinScene<N, E, ?> graphPinScene, final GraphLayout<N, E> graphLayout) {
        assert (graphPinScene != null && graphLayout != null);
        return new SceneLayout(graphPinScene){

            protected void performLayout() {
                graphLayout.layoutGraph(graphPinScene);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionWidgetLayoutAlignment {
        NONE,
        CENTER,
        TOP_CENTER,
        BOTTOM_CENTER,
        CENTER_LEFT,
        CENTER_RIGHT,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER_SOURCE,
        CENTER_TARGET,
        BOTTOM_SOURCE,
        BOTTOM_TARGET,
        TOP_SOURCE,
        TOP_TARGET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SerialAlignment {
        LEFT_TOP,
        CENTER,
        RIGHT_BOTTOM,
        JUSTIFY;

    }
}

