/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMDGraphScene
extends GraphPinScene<String, String, String> {
    public static final String PIN_ID_DEFAULT_SUFFIX = "#default";
    private LayerWidget backgroundLayer = new LayerWidget(this);
    private LayerWidget mainLayer = new LayerWidget(this);
    private LayerWidget connectionLayer = new LayerWidget(this);
    private LayerWidget upperLayer = new LayerWidget(this);
    private Router router;
    private WidgetAction moveControlPointAction = ActionFactory.createOrthogonalMoveControlPointAction();
    private WidgetAction moveAction = ActionFactory.createMoveAction();
    private SceneLayout sceneLayout;
    private VMDColorScheme scheme;

    public VMDGraphScene() {
        this(VMDFactory.getOriginalScheme());
    }

    public VMDGraphScene(VMDColorScheme scheme) {
        this.scheme = scheme;
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.addChild(this.backgroundLayer);
        this.addChild(this.mainLayer);
        this.addChild(this.connectionLayer);
        this.addChild(this.upperLayer);
        this.router = RouterFactory.createOrthogonalSearchRouter(this.mainLayer, this.connectionLayer);
        this.getActions().addAction(ActionFactory.createZoomAction());
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createRectangularSelectAction(this, this.backgroundLayer));
        this.sceneLayout = LayoutFactory.createSceneGraphLayout(this, new GridGraphLayout().setChecker(true));
    }

    @Override
    protected Widget attachNodeWidget(String node) {
        VMDNodeWidget widget = new VMDNodeWidget(this, this.scheme);
        this.mainLayer.addChild(widget);
        widget.getHeader().getActions().addAction(this.createObjectHoverAction());
        widget.getActions().addAction(this.createSelectAction());
        widget.getActions().addAction(this.moveAction);
        return widget;
    }

    @Override
    protected Widget attachPinWidget(String node, String pin) {
        if (pin.endsWith(PIN_ID_DEFAULT_SUFFIX)) {
            return null;
        }
        VMDPinWidget widget = new VMDPinWidget(this, this.scheme);
        ((VMDNodeWidget)this.findWidget(node)).attachPinWidget(widget);
        widget.getActions().addAction(this.createObjectHoverAction());
        widget.getActions().addAction(this.createSelectAction());
        return widget;
    }

    @Override
    protected Widget attachEdgeWidget(String edge) {
        VMDConnectionWidget connectionWidget = new VMDConnectionWidget((Scene)this, this.scheme);
        connectionWidget.setRouter(this.router);
        this.connectionLayer.addChild(connectionWidget);
        connectionWidget.getActions().addAction(this.createObjectHoverAction());
        connectionWidget.getActions().addAction(this.createSelectAction());
        connectionWidget.getActions().addAction(this.moveControlPointAction);
        return connectionWidget;
    }

    @Override
    protected void attachEdgeSourceAnchor(String edge, String oldSourcePin, String sourcePin) {
        ((ConnectionWidget)this.findWidget(edge)).setSourceAnchor(this.getPinAnchor(sourcePin));
    }

    @Override
    protected void attachEdgeTargetAnchor(String edge, String oldTargetPin, String targetPin) {
        ((ConnectionWidget)this.findWidget(edge)).setTargetAnchor(this.getPinAnchor(targetPin));
    }

    private Anchor getPinAnchor(String pin) {
        Anchor anchor;
        if (pin == null) {
            return null;
        }
        VMDNodeWidget nodeWidget = (VMDNodeWidget)this.findWidget(this.getPinNode(pin));
        Widget pinMainWidget = this.findWidget(pin);
        if (pinMainWidget != null) {
            anchor = AnchorFactory.createDirectionalAnchor(pinMainWidget, AnchorFactory.DirectionalAnchorKind.HORIZONTAL, 8);
            anchor = nodeWidget.createAnchorPin(anchor);
        } else {
            anchor = nodeWidget.getNodeAnchor();
        }
        return anchor;
    }

    public void layoutScene() {
        this.sceneLayout.invokeLayout();
    }
}

