/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Graphics2D;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.AnchorShapeLocationResolver;

public class AttachableAnchorShape
implements AnchorShape {
    private AnchorShape shape = null;
    private AnchorShapeLocationResolver locationResolver = null;

    public AttachableAnchorShape() {
        this(AnchorShape.NONE);
    }

    public AttachableAnchorShape(AnchorShapeLocationResolver resolver) {
        this(AnchorShape.NONE, resolver);
    }

    public AttachableAnchorShape(AnchorShape shape) {
        this(shape, null);
    }

    public AttachableAnchorShape(AnchorShape shape, AnchorShapeLocationResolver resolver) {
        this.shape = shape;
        this.locationResolver = resolver;
    }

    public AnchorShape getShape() {
        return this.shape;
    }

    public void setShape(AnchorShape shape) {
        this.shape = shape;
    }

    public AnchorShapeLocationResolver getLocationResolver() {
        return this.locationResolver;
    }

    public void setLocationResolver(AnchorShapeLocationResolver locationResolver) {
        this.locationResolver = locationResolver;
    }

    public boolean isLineOriented() {
        return this.shape.isLineOriented();
    }

    public int getRadius() {
        return this.shape.getRadius();
    }

    public double getCutDistance() {
        return this.shape.getCutDistance() + (double)this.getAdditionalDistance();
    }

    public void paint(Graphics2D graphics, boolean source) {
        int distance = this.getAdditionalDistance();
        graphics.translate(distance, 0);
        this.shape.paint(graphics, source);
        graphics.translate(-distance, 0);
    }

    protected int getAdditionalDistance() {
        int retVal = 0;
        if (this.locationResolver != null) {
            retVal = this.locationResolver.getEndLocation();
        }
        return retVal;
    }
}

