/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public final class DirectionalAnchor
extends Anchor {
    private AnchorFactory.DirectionalAnchorKind kind;
    private int gap;

    public DirectionalAnchor(Widget widget, AnchorFactory.DirectionalAnchorKind kind, int gap) {
        super(widget);
        this.kind = kind;
        this.gap = gap;
    }

    public Anchor.Result compute(Anchor.Entry entry) {
        Point relatedLocation = this.getRelatedSceneLocation();
        Point oppositeLocation = this.getOppositeSceneLocation(entry);
        Widget widget = this.getRelatedWidget();
        Rectangle bounds = widget.convertLocalToScene(widget.getBounds());
        Point center = GeomUtil.center(bounds);
        switch (this.kind) {
            case HORIZONTAL: {
                if (relatedLocation.x >= oppositeLocation.x) {
                    return (Anchor)this.new Anchor.Result(new Point(bounds.x - this.gap, center.y), Anchor.Direction.LEFT);
                }
                return (Anchor)this.new Anchor.Result(new Point(bounds.x + bounds.width + this.gap, center.y), Anchor.Direction.RIGHT);
            }
            case VERTICAL: {
                if (relatedLocation.y >= oppositeLocation.y) {
                    return (Anchor)this.new Anchor.Result(new Point(center.x, bounds.y - this.gap), Anchor.Direction.TOP);
                }
                return (Anchor)this.new Anchor.Result(new Point(center.x, bounds.y + bounds.height + this.gap), Anchor.Direction.BOTTOM);
            }
        }
        return null;
    }
}

