/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeGraphLayout<N, E>
extends GraphLayout<N, E> {
    private int originX;
    private int originY;
    private int verticalGap;
    private int horizontalGap;
    private boolean vertical;
    private N rootNode;

    public TreeGraphLayout(int originX, int originY, int verticalGap, int horizontalGap, boolean vertical) {
        this.originX = originX;
        this.originY = originY;
        this.verticalGap = verticalGap;
        this.horizontalGap = horizontalGap;
        this.vertical = vertical;
    }

    public void setRootNode(N rootNode) {
        this.rootNode = rootNode;
    }

    public void setProperties(int originX, int originY, int verticalGap, int horizontalGap, boolean vertical) {
        this.originX = originX;
        this.originY = originY;
        this.verticalGap = verticalGap;
        this.horizontalGap = horizontalGap;
        this.vertical = vertical;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        if (this.rootNode == null) {
            return;
        }
        Collection<N> allNodes = graph.getNodes();
        if (!allNodes.contains(this.rootNode)) {
            return;
        }
        ArrayList<N> nodesToResolve = new ArrayList<N>(allNodes);
        HashSet loadedSet = new HashSet();
        Node root = new Node(graph, this.rootNode, loadedSet);
        nodesToResolve.removeAll(loadedSet);
        if (this.vertical) {
            root.allocateHorizontally(graph);
            root.resolveVertically(this.originX, this.originY);
        } else {
            root.allocateVertically(graph);
            root.resolveHorizontally(this.originX, this.originY);
        }
        HashMap<N, Point> resultPosition = new HashMap<N, Point>();
        root.upload(resultPosition);
        for (N n : nodesToResolve) {
            Point position = new Point();
            resultPosition.put(n, position);
        }
        for (Map.Entry entry : resultPosition.entrySet()) {
            this.setResolvedNodeLocation(graph, entry.getKey(), (Point)entry.getValue());
        }
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> nodes) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private N node;
        private ArrayList<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private int totalSpace;
        private Point point;

        private Node(UniversalGraph<N, E> graph, N node, HashSet<N> loadedSet) {
            this.node = node;
            loadedSet.add(node);
            this.children = new ArrayList();
            for (Object edge : graph.findNodeEdges(node, true, false)) {
                Object child = graph.getEdgeTarget(edge);
                if (child == null || loadedSet.contains(child)) continue;
                this.children.add(new Node(graph, child, loadedSet));
            }
        }

        private int allocateHorizontally(UniversalGraph<N, E> graph) {
            Widget widget = graph.getScene().findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.horizontalGap;
                }
                this.space += this.children.get(i).allocateHorizontally(graph);
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.width);
            return this.totalSpace;
        }

        private void resolveVertically(int x, int y) {
            this.point = new Point(x + this.totalSpace / 2, y - this.relativeBounds.y);
            x += (this.totalSpace - this.space) / 2;
            y += this.relativeBounds.height + TreeGraphLayout.this.verticalGap;
            for (Node child : this.children) {
                child.resolveVertically(x, y);
                x += child.totalSpace + TreeGraphLayout.this.horizontalGap;
            }
        }

        private int allocateVertically(UniversalGraph<N, E> graph) {
            Widget widget = graph.getScene().findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.verticalGap;
                }
                this.space += this.children.get(i).allocateVertically(graph);
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.height);
            return this.totalSpace;
        }

        private void resolveHorizontally(int x, int y) {
            this.point = new Point(x - this.relativeBounds.x, y + this.totalSpace / 2);
            x += this.relativeBounds.width + TreeGraphLayout.this.horizontalGap;
            y += (this.totalSpace - this.space) / 2;
            for (Node child : this.children) {
                child.resolveHorizontally(x, y);
                y += child.totalSpace + TreeGraphLayout.this.verticalGap;
            }
        }

        private void upload(HashMap<N, Point> result) {
            result.put(this.node, this.point);
            for (Node child : this.children) {
                child.upload(result);
            }
        }
    }
}

