/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class NamedServicesProvider {
    private static final Map<String, Reference<Lookup>> map = Collections.synchronizedMap(new HashMap());

    public abstract Lookup create(String var1);

    public static Lookup find(String path) {
        Reference<Lookup> ref;
        Lookup lkp;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Lookup lookup = lkp = (ref = map.get(path)) == null ? null : ref.get();
        if (lkp != null) {
            return lkp;
        }
        NamedServicesProvider prov = Lookup.getDefault().lookup(NamedServicesProvider.class);
        if (prov != null) {
            lkp = prov.create(path);
        } else {
            ClassLoader l = Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null && (l = Thread.currentThread().getContextClassLoader()) == null) {
                l = NamedServicesProvider.class.getClassLoader();
            }
            lkp = Lookups.metaInfServices(l, "META-INF/namedservices/" + path);
        }
        map.put(path, new WeakReference<Lookup>(lkp));
        return lkp;
    }
}

