/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.dbms;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public final class OracleUtils {
    static final Class[] CREATE_TEMP_ARGS = new Class[]{Connection.class, Boolean.TYPE, Integer.TYPE};

    public static BLOB createTemporaryBLOB(Connection c3p0ProxyCon, boolean cache, int duration) throws SQLException {
        if (c3p0ProxyCon instanceof C3P0ProxyConnection) {
            try {
                C3P0ProxyConnection castCon = (C3P0ProxyConnection)c3p0ProxyCon;
                Method m = BLOB.class.getMethod("createTemporary", CREATE_TEMP_ARGS);
                Object[] args = new Object[]{C3P0ProxyConnection.RAW_CONNECTION, cache, new Integer(duration)};
                return (BLOB)castCon.rawConnectionOperation(m, null, args);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw SqlUtils.toSQLException((Throwable)e.getTargetException());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw SqlUtils.toSQLException((Throwable)e);
            }
        }
        if (c3p0ProxyCon instanceof OracleConnection) {
            return BLOB.createTemporary((Connection)c3p0ProxyCon, (boolean)cache, (int)duration);
        }
        throw new SQLException("Cannot create an oracle BLOB from a Connection that is neither an oracle.jdbc.driver.Connection, nor a C3P0ProxyConnection wrapped around an oracle.jdbc.driver.Connection.");
    }

    public static CLOB createTemporaryCLOB(Connection c3p0ProxyCon, boolean cache, int duration) throws SQLException {
        if (c3p0ProxyCon instanceof C3P0ProxyConnection) {
            try {
                C3P0ProxyConnection castCon = (C3P0ProxyConnection)c3p0ProxyCon;
                Method m = CLOB.class.getMethod("createTemporary", CREATE_TEMP_ARGS);
                Object[] args = new Object[]{C3P0ProxyConnection.RAW_CONNECTION, cache, new Integer(duration)};
                return (CLOB)castCon.rawConnectionOperation(m, null, args);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw SqlUtils.toSQLException((Throwable)e.getTargetException());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw SqlUtils.toSQLException((Throwable)e);
            }
        }
        if (c3p0ProxyCon instanceof OracleConnection) {
            return CLOB.createTemporary((Connection)c3p0ProxyCon, (boolean)cache, (int)duration);
        }
        throw new SQLException("Cannot create an oracle CLOB from a Connection that is neither an oracle.jdbc.driver.Connection, nor a C3P0ProxyConnection wrapped around an oracle.jdbc.driver.Connection.");
    }

    private OracleUtils() {
    }
}

