/*
 * Decompiled with CFR 0.152.
 */
package test.functional.inventory;

import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import test.AdempiereTestCase;
import test.functional.inventory.CSVFactory;
import test.functional.inventory.InventoryTestException;
import test.functional.inventory.InventoryUtil;
import test.functional.inventory.MMDocument;
import test.functional.inventory.MMScenario;

public class InventoryTest
extends AdempiereTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Env.setContext((Properties)Env.getCtx(), (String)"$C_Currency_ID", (int)346);
        Env.setContext((Properties)Env.getCtx(), (String)"#M_Warehouse_ID", (int)-1);
        Env.setContext((Properties)Env.getCtx(), (String)"#PO_PriceList_ID", (int)InventoryUtil.getCreatePriceList("junit-PO", false).get_ID());
        Env.setContext((Properties)Env.getCtx(), (String)"#SO_PriceList_ID", (int)InventoryUtil.getCreatePriceList("junit-SO", true).get_ID());
    }

    public void test01() throws Exception {
        InputStream in;
        if (System.getProperty("TestFile") != null) {
            in = new FileInputStream(System.getProperty("TestFile"));
        } else {
            String url = "http://spreadsheets.google.com/pub?key=p_F3GDtQxWTA9YbH8MRkyKA&output=csv&gid=0";
            in = new URL(url).openStream();
        }
        CSVFactory factory = new CSVFactory();
        Collection<MMScenario> tests = factory.read(in);
        String trxName = this.getTrxName();
        for (MMScenario scenario : tests) {
            this.runMMScenario(scenario, trxName);
        }
    }

    private void runMMScenario(MMScenario scenario, String trxName) {
        scenario.key = "" + System.currentTimeMillis();
        for (MMDocument doc : scenario.docs) {
            boolean ok = false;
            try {
                try {
                    this.createDocument(doc, trxName);
                    ok = true;
                }
                catch (Exception e) {
                    InventoryTestException ie = e instanceof InventoryTestException ? (InventoryTestException)e : new InventoryTestException(e);
                    ie.scenario = scenario;
                    ie.document = doc;
                    throw ie;
                }
            }
            catch (Throwable throwable) {
                if (!ok) {
                    this.dumpStatus(doc, trxName);
                    try {
                        this.commit();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (ok) continue;
            this.dumpStatus(doc, trxName);
            try {
                this.commit();
            }
            catch (Exception exception) {}
        }
    }

    private void createDocument(final MMDocument doc, String trxName) {
        Trx.run((String)trxName, (TrxRunnable)new TrxRunnable(){

            public void run(String trxName) {
                if (doc.IsReversal) {
                    MMDocument docOrig = doc.scenario.get(doc.DocBaseType, doc.DocumentNo);
                    doc.ProductValue = docOrig.ProductValue;
                    doc.LocatorValue = docOrig.LocatorValue;
                    doc.LocatorValueTo = docOrig.LocatorValueTo;
                    InventoryUtil.processDocument(docOrig, "RC", "RE");
                    return;
                }
                if (doc.ProductValue == null) {
                    throw new RuntimeException("ProductValue is null");
                }
                doc.ProductValue = "junit-" + doc.ProductValue + "-" + doc.scenario.key;
                if (doc.scenario.get(doc.DocBaseType, doc.DocumentNo) != null) {
                    throw new AdempiereException("DocumentNo conflict - " + doc.DocumentNo);
                }
                if ("POO".equals(doc.DocBaseType) || "SOO".equals(doc.DocBaseType)) {
                    InventoryUtil.createOrder(doc, trxName);
                } else if ("MMR".equals(doc.DocBaseType) || "MMS".equals(doc.DocBaseType)) {
                    InventoryUtil.createInOut(doc, trxName);
                } else if ("MMM".equals(doc.DocBaseType)) {
                    InventoryUtil.createMovement(doc, trxName);
                } else if ("MMI".equals(doc.DocBaseType)) {
                    InventoryUtil.createInventory(doc, trxName);
                } else if ("TST".equals(doc.DocBaseType)) {
                    InventoryTest.this.assertStorage(doc, trxName);
                } else {
                    throw new AdempiereException("DocBaseType not supported for " + doc);
                }
            }
        });
    }

    private void assertStorage(MMDocument doc, String trxName) {
        MLocator locator = InventoryUtil.getCreateLocator(-1, doc.LocatorValue, doc.LocatorValue);
        MProduct product = InventoryUtil.getCreateProduct(doc.ProductValue, null);
        int M_ASI_ID = -1;
        if (!Util.isEmpty((String)doc.ASI, (boolean)true)) {
            M_ASI_ID = doc.scenario.getM_ASI_ID(doc.ASI);
        }
        ArrayList<Integer> params = new ArrayList<Integer>();
        String sql = "SELECT COALESCE(SUM(QtyOnHand),0),COALESCE(SUM(QtyReserved),0),COALESCE(SUM(QtyOrdered),0) FROM M_Storage WHERE M_Locator_ID=? AND M_Product_ID=?";
        params.add(locator.get_ID());
        params.add(product.get_ID());
        if (M_ASI_ID >= 0) {
            sql = String.valueOf(sql) + " AND M_AttributeSetInstance_ID=?";
            params.add(M_ASI_ID);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal qtyOnHand = Env.ZERO;
        BigDecimal qtyOrdered = Env.ZERO;
        BigDecimal qtyReserved = Env.ZERO;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    qtyOnHand = rs.getBigDecimal(1);
                    qtyReserved = rs.getBigDecimal(2);
                    qtyOrdered = rs.getBigDecimal(3);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        InventoryTest.assertEquals((String)("QtyOnHand not match " + doc), (Object)doc.Qty, (Object)qtyOnHand);
        InventoryTest.assertEquals((String)("QtyReserved not match " + doc), (Object)doc.QtyReserved, (Object)qtyReserved);
        InventoryTest.assertEquals((String)("QtyOrdered not match " + doc), (Object)doc.QtyOrdered, (Object)qtyOrdered);
    }

    private void dumpStatus(MMDocument doc, String trxName) {
        MProduct product = InventoryUtil.getCreateProduct(doc.ProductValue, null);
        MStorage[] storage = MStorage.getOfProduct((Properties)this.getCtx(), (int)product.get_ID(), (String)trxName);
        System.err.println("STORAGE____________________________________________________");
        System.err.println("   " + doc);
        MStorage[] mStorageArray = storage;
        int n = storage.length;
        int n2 = 0;
        while (n2 < n) {
            MStorage s = mStorageArray[n2];
            System.err.println("" + s);
            ++n2;
        }
        System.err.println(doc.scenario.toString());
        System.err.println("___________________________________________________________");
        System.err.flush();
        System.err.flush();
    }
}

