/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import fit.exception.NoSuchFieldFitFailureException;
import fit.exception.NoSuchMethodFitFailureException;
import util.RegexTestCase;

public class BindingTest
extends RegexTestCase {
    private TestFixture fixture;
    private Parse cell1;
    private Parse cell2;
    private Parse cell3;
    private Parse cell4;

    protected void setUp() throws Exception {
        this.fixture = new TestFixture();
        Parse table = new Parse("<table><tr><td>123</td><td>321</td><td>abc</td><td></td></tr></table>");
        this.cell1 = table.parts.parts;
        this.cell2 = table.parts.parts.more;
        this.cell3 = table.parts.parts.more.more;
        this.cell4 = table.parts.parts.more.more.more;
    }

    public void testConstruction() throws Throwable {
        BindingTest.assertEquals(Binding.QueryBinding.class, Binding.create(this.fixture, "intMethod()").getClass());
        BindingTest.assertEquals(Binding.QueryBinding.class, Binding.create(this.fixture, "intMethod?").getClass());
        BindingTest.assertEquals(Binding.QueryBinding.class, Binding.create(this.fixture, "intMethod!").getClass());
        BindingTest.assertEquals(Binding.SetBinding.class, Binding.create(this.fixture, "intField").getClass());
        BindingTest.assertEquals(Binding.RecallBinding.class, Binding.create(this.fixture, "intField=").getClass());
        BindingTest.assertEquals(Binding.SaveBinding.class, Binding.create(this.fixture, "=intMethod()").getClass());
        BindingTest.assertEquals(Binding.SaveBinding.class, Binding.create(this.fixture, "=intField").getClass());
    }

    public void testQueryBinding() throws Throwable {
        Binding binding = Binding.create(this.fixture, "intMethod()");
        binding.doCell(this.fixture, this.cell1);
        BindingTest.assertEquals((int)1, (int)this.fixture.counts.wrong);
        this.fixture.intField = 321;
        binding.doCell(this.fixture, this.cell2);
        BindingTest.assertEquals((int)1, (int)this.fixture.counts.right);
    }

    public void testSetBinding() throws Throwable {
        Binding binding = Binding.create(this.fixture, "intField");
        binding.doCell(this.fixture, this.cell1);
        BindingTest.assertEquals((int)123, (int)this.fixture.intField);
        binding.doCell(this.fixture, this.cell2);
        BindingTest.assertEquals((int)321, (int)this.fixture.intField);
    }

    public void testQueryBindingWithBlankCell() throws Throwable {
        Binding binding = Binding.create(this.fixture, "intField");
        binding.doCell(this.fixture, this.cell4);
        BindingTest.assertSubString((String)"0", (String)this.cell4.text());
    }

    public void testSaveBinding() throws Throwable {
        Binding binding = Binding.create(this.fixture, "=intMethod()");
        binding.doCell(this.fixture, this.cell1);
        BindingTest.assertEquals((Object)"0", (Object)Fixture.getSymbol("123"));
        BindingTest.assertSubString((String)"123  = 0", (String)this.cell1.text());
        this.fixture.intField = 999;
        binding.doCell(this.fixture, this.cell2);
        BindingTest.assertEquals((Object)"999", (Object)Fixture.getSymbol("321"));
    }

    public void testSaveBindingWithNull() throws Throwable {
        Binding binding = Binding.create(this.fixture, "=integerMethodIsNull()");
        this.fixture.integerField = null;
        binding.doCell(this.fixture, this.cell1);
        BindingTest.assertEquals((Object)"null", (Object)Fixture.getSymbol("123"));
        BindingTest.assertSubString((String)"123  = null", (String)this.cell1.text());
        binding.doCell(this.fixture, this.cell2);
        BindingTest.assertEquals((Object)"null", (Object)Fixture.getSymbol("321"));
    }

    public void testRecallBinding() throws Throwable {
        Binding binding = Binding.create(this.fixture, "intField=");
        Fixture.setSymbol("123", "999");
        binding.doCell(this.fixture, this.cell1);
        BindingTest.assertEquals((int)999, (int)this.fixture.intField);
        binding.doCell(this.fixture, this.cell3);
        BindingTest.assertSubString((String)"No such symbol: abc", (String)this.cell3.text());
    }

    public void testRecallBindingWithNull() throws Throwable {
        Binding binding = Binding.create(this.fixture, "integerField=");
        Fixture.setSymbol("123", null);
        binding.doCell(this.fixture, this.cell1);
        BindingTest.assertEquals(null, (Object)this.fixture.integerField);
    }

    public void testRecallBindingSymbolTableText() throws Throwable {
        Binding binding = Binding.create(this.fixture, "intField=");
        Fixture.setSymbol("123", "999");
        binding.doCell(this.fixture, this.cell1);
        BindingTest.assertEquals((String)"123  = 999", (String)this.cell1.text());
    }

    public void testUseOfGracefulNamingForMethods() throws Throwable {
        this.checkForMethodBinding("intMethod()", true);
        this.checkForMethodBinding("int Method?", true);
        this.checkForMethodBinding("int method?", true);
        this.checkForMethodBinding("intmethod?", false);
        this.checkForMethodBinding("Intmethod?", false);
        this.checkForMethodBinding("IntMethod?", false);
    }

    public void testUseOfGracefulNamingForFields() throws Throwable {
        this.checkForFieldBinding("intField", true);
        this.checkForFieldBinding("int Field", true);
        this.checkForFieldBinding("int field", true);
        this.checkForFieldBinding("intfield", false);
        this.checkForFieldBinding("Intfield", false);
        this.checkForFieldBinding("IntField", false);
    }

    private void checkForMethodBinding(String name, boolean expected) throws Throwable {
        Binding binding = null;
        try {
            binding = Binding.create(this.fixture, name);
        }
        catch (NoSuchMethodFitFailureException e) {
            BindingTest.assertFalse((String)"method not found", (boolean)expected);
            return;
        }
        BindingTest.assertTrue((String)"method was found", (boolean)expected);
        BindingTest.assertTrue((boolean)(binding instanceof Binding.QueryBinding));
        BindingTest.assertEquals((String)"intMethod", (String)binding.adapter.method.getName());
    }

    private void checkForFieldBinding(String name, boolean expected) throws Throwable {
        Binding binding = null;
        try {
            binding = Binding.create(this.fixture, name);
        }
        catch (NoSuchFieldFitFailureException e) {
            BindingTest.assertFalse((String)"field not found", (boolean)expected);
            return;
        }
        BindingTest.assertTrue((String)"field was found", (boolean)expected);
        BindingTest.assertTrue((boolean)(binding instanceof Binding.SetBinding));
        BindingTest.assertEquals((String)"intField", (String)binding.adapter.field.getName());
    }

    public static class TestFixture
    extends Fixture {
        public int intField = 0;
        public Integer integerField = 42;

        public int intMethod() {
            return this.intField;
        }

        public Integer integerMethodIsNull() {
            return this.integerField;
        }
    }
}

