/*
 * Decompiled with CFR 0.152.
 */
package fit;

public class ScientificDouble
extends Number
implements Comparable<Number> {
    private static final long serialVersionUID = 1L;
    protected double value;
    protected double precision;

    public ScientificDouble(double value) {
        this.value = value;
        this.precision = 0.0;
    }

    public static ScientificDouble valueOf(String s) {
        ScientificDouble result = new ScientificDouble(Double.parseDouble(s));
        result.precision = ScientificDouble.precision(s);
        return result;
    }

    public static ScientificDouble parse(String s) {
        return ScientificDouble.valueOf(s);
    }

    public static double precision(String s) {
        double value = Double.parseDouble(s);
        double bound = Double.parseDouble(ScientificDouble.tweak(s.trim()));
        return Math.abs(bound - value);
    }

    public static String tweak(String s) {
        int pos = s.toLowerCase().indexOf("e");
        if (pos >= 0) {
            return ScientificDouble.tweak(s.substring(0, pos)) + s.substring(pos);
        }
        if (s.indexOf(".") >= 0) {
            return s + "5";
        }
        return s + ".5";
    }

    public boolean equals(Object obj) {
        return this.compareTo((Number)obj) == 0;
    }

    @Override
    public int compareTo(Number obj) {
        double other = obj.doubleValue();
        double diff = this.value - other;
        if (diff < -this.precision) {
            return -1;
        }
        if (diff > this.precision) {
            return 1;
        }
        if (Double.isNaN(this.value) && Double.isNaN(other)) {
            return 0;
        }
        if (Double.isNaN(this.value)) {
            return 1;
        }
        if (Double.isNaN(other)) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

