/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch;

import fit.Counts;
import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.resultsOut.ParallelSuiteResult;
import fitlibrary.batch.testRun.ParallelTestRunner;
import fitlibrary.batch.testRun.RetryAwareFitLibraryTestEngine;
import fitlibrary.definedAction.DefineActionsOnPageSlowly;
import fitlibrary.differences.FitLibraryRunnerDifference;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.ConfigureLoggingThroughFiles;
import fitlibrary.traverse.Traverse;
import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;

public class FitLibraryRunner {
    static int PORT_NO = 8980;

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length > 0 && args[0].startsWith("-")) {
            FitLibraryRunner.runWithNewArguments(args);
        } else {
            FitLibraryRunner.runWithOldArguments(args);
        }
    }

    private static void runWithNewArguments(String[] args) throws IOException, InterruptedException {
        System.out.println("FitLibraryRunner diry is " + new File(".").getAbsolutePath());
        try {
            RunParameters runParameters = RunParameters.getRunParameters(args);
            String fitNesseDirectoryPath = runParameters.get(RunParameters.ValidParameters.FIT_NESSE_DIRY);
            ConfigureLoggingThroughFiles.configure(fitNesseDirectoryPath + "/");
            FitLibraryRunner.runParallel(runParameters.get(RunParameters.ValidParameters.SUITE_NAME), fitNesseDirectoryPath, runParameters.get(RunParameters.ValidParameters.RESULTS_DIRY), runParameters.getBoolean(RunParameters.ValidParameters.SHOW_PASSES), runParameters.getInt(RunParameters.ValidParameters.PORT), runParameters.getInt(RunParameters.ValidParameters.RETRIES), runParameters.getBoolean(RunParameters.ValidParameters.JUNIT_XML_OUTPUT));
        }
        catch (InvalidParameterException e) {
            FitLibraryRunner.error();
        }
        catch (NumberFormatException e) {
            FitLibraryRunner.error();
        }
    }

    private static void error() {
        System.err.println("Usage: fitlibrary.batch.FitLibraryRunner -suiteName suiteName [-fitNesseDiry fitNesseDiry] [-resultsDiry resultsDiry] [-showPasses true] [-port port]");
        System.exit(-1);
    }

    private static void runWithOldArguments(String[] args) throws IOException, InterruptedException {
        if (args.length != 3 && args.length != 4) {
            FitLibraryRunner.error();
        }
        String suiteName = args[0];
        String fitNesseDirectoryPath = args[1];
        String resultsDirectoryPath = args[2];
        boolean showPasses = args.length == 4;
        FitLibraryRunner.runParallel(suiteName, fitNesseDirectoryPath, resultsDirectoryPath, showPasses, PORT_NO, 0, false);
    }

    private static void runParallel(String suiteName, String fitNesseDirectoryPath, String resultsDirectoryPath, boolean showPasses, int port, int maxRetries, boolean junitXmlOutput) throws IOException, InterruptedException {
        Counts counts;
        FitLibraryRunner.verifyFitNesseDirectory(fitNesseDirectoryPath);
        DefineActionsOnPageSlowly.setFitNesseDiry(fitNesseDirectoryPath);
        Traverse.setDifferenceStrategy(new FitLibraryRunnerDifference(fitNesseDirectoryPath));
        long start = System.currentTimeMillis();
        HashSet<String> passedTestList = new HashSet<String>();
        RetryAwareFitLibraryTestEngine testEngine = new RetryAwareFitLibraryTestEngine(passedTestList);
        int numLoops = 1;
        while (true) {
            ParallelTestRunner runner = new ParallelTestRunner(new ParallelFitNesseRepository(fitNesseDirectoryPath, port), testEngine, resultsDirectoryPath, showPasses, suiteName, junitXmlOutput);
            counts = runner.runSuite(suiteName, new ParallelSuiteResult(suiteName, showPasses));
            FitLibraryRunner.report(start, counts);
            if (counts.exceptions + counts.wrong == 0 || numLoops++ > maxRetries) break;
            System.out.println(" ");
            System.out.println("Some tests failed... Retry #" + (numLoops - 1));
        }
        System.exit(counts.wrong + counts.exceptions);
    }

    private static void verifyFitNesseDirectory(String fitNesseDirectoryPath) {
        File fitNesseDiry = new File(fitNesseDirectoryPath);
        if (!fitNesseDiry.isDirectory()) {
            throw new FitLibraryException("Not a directory: " + fitNesseDirectoryPath);
        }
        if (!Arrays.asList(fitNesseDiry.list()).contains("FitNesseRoot")) {
            throw new FitLibraryException("Does not contain FitNesseRoot: " + fitNesseDirectoryPath);
        }
    }

    static String formatTime(long elapsedTimeMillis) {
        if (elapsedTimeMillis < 1000L) {
            return elapsedTimeMillis + " milliseconds.";
        }
        String format = "s' seconds'";
        if (elapsedTimeMillis >= 60000L) {
            format = "m 'minutes' " + format;
        }
        if (elapsedTimeMillis >= 3600000L) {
            format = "h 'hours' " + format;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        return df.format(new Date(elapsedTimeMillis)) + " (" + elapsedTimeMillis + " milliseconds).";
    }

    private static void report(long start, Counts counts) {
        System.out.println("Total right=" + counts.right + ", wrong=" + counts.wrong + ", ignores=" + counts.ignores + ", exceptions=" + counts.exceptions);
        System.out.println("Time since start = " + FitLibraryRunner.formatTime(System.currentTimeMillis() - start));
    }

    public static RunParameters getRunParameters(String[] args) {
        return RunParameters.getRunParameters(args);
    }

    public static class RunParameters {
        private Map<ValidParameters, String> parameterMap = new HashMap<ValidParameters, String>();

        public RunParameters() {
            for (ValidParameters param : ValidParameters.values()) {
                this.parameterMap.put(param, param.defaultValue());
            }
        }

        public static RunParameters getRunParameters(String[] args) {
            RunParameters runParameters = new RunParameters();
            for (int i = 0; i < args.length; ++i) {
                String tag = args[i];
                if (!tag.startsWith("-")) continue;
                tag = tag.substring(1);
                if (++i < args.length) {
                    runParameters.put(ValidParameters.parseFromParameterName(tag), args[i]);
                    continue;
                }
                throw new InvalidParameterException(tag);
            }
            if (runParameters.get(ValidParameters.SUITE_NAME) == null) {
                throw new InvalidParameterException("suiteName");
            }
            return runParameters;
        }

        public int getInt(ValidParameters key) {
            return Integer.parseInt(this.get(key));
        }

        public boolean getBoolean(ValidParameters key) {
            return Boolean.parseBoolean(this.get(key));
        }

        public String get(ValidParameters key) {
            return this.parameterMap.get((Object)key);
        }

        public void put(ValidParameters key, String value) {
            this.parameterMap.put(key, value);
        }

        public static enum ValidParameters {
            SUITE_NAME{

                @Override
                public String parameterName() {
                    return "suiteName";
                }

                @Override
                public String defaultValue() {
                    return null;
                }
            }
            ,
            FIT_NESSE_DIRY{

                @Override
                public String parameterName() {
                    return "fitNesseDiry";
                }

                @Override
                public String defaultValue() {
                    return ".";
                }
            }
            ,
            RESULTS_DIRY{

                @Override
                public String parameterName() {
                    return "resultsDiry";
                }

                @Override
                public String defaultValue() {
                    return "runnerResults";
                }
            }
            ,
            SHOW_PASSES{

                @Override
                public String parameterName() {
                    return "showPasses";
                }

                @Override
                public String defaultValue() {
                    return "false";
                }
            }
            ,
            PORT{

                @Override
                public String parameterName() {
                    return "port";
                }

                @Override
                public String defaultValue() {
                    return "80";
                }
            }
            ,
            RETRIES{

                @Override
                public String parameterName() {
                    return "retries";
                }

                @Override
                public String defaultValue() {
                    return "0";
                }
            }
            ,
            JUNIT_XML_OUTPUT{

                @Override
                public String parameterName() {
                    return "junitXmlOutput";
                }

                @Override
                public String defaultValue() {
                    return "false";
                }
            };


            abstract String parameterName();

            abstract String defaultValue();

            public static ValidParameters parseFromParameterName(String parameterName) {
                for (ValidParameters param : ValidParameters.values()) {
                    if (!parameterName.equals(param.parameterName())) continue;
                    return param;
                }
                throw new InvalidParameterException(parameterName);
            }
        }
    }
}

