/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch;

import fit.Counts;
import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.fitnesseIn.ParallelTestRepository;
import fitlibrary.batch.resultsOut.ParallelTestResultRepository;
import fitlibrary.batch.resultsOut.SuiteResult;
import fitlibrary.batch.testRun.ParallelTestRunner;
import fitlibrary.batch.trinidad.InMemoryTestImpl;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitlibrary.batch.trinidad.TestEngine;
import fitlibrary.batch.trinidad.TestResult;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestParallelTestRunner {
    final Mockery context = new JUnit4Mockery();
    final Counts countsZero = new Counts(0, 0, 0, 0);
    final Counts countsOnes = new Counts(1, 1, 1, 1);
    final ParallelTestRepository repository = (ParallelTestRepository)this.context.mock(ParallelTestRepository.class);
    final TestEngine testEngine = (TestEngine)this.context.mock(TestEngine.class);
    final ParallelTestResultRepository resultRepository = (ParallelTestResultRepository)this.context.mock(ParallelTestResultRepository.class);
    final SuiteResult suiteResult = (SuiteResult)this.context.mock(SuiteResult.class);
    final BlockingQueue<TestDescriptor> queue = new LinkedBlockingQueue<TestDescriptor>();
    final InMemoryTestImpl test1 = new InMemoryTestImpl("TestOne", "One Contents");
    final TestResult result1 = (TestResult)this.context.mock(TestResult.class);

    @Before
    public void before() throws IOException, InterruptedException {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParallelTestRepository)this.one(TestParallelTestRunner.this.repository)).prepareResultRepository(TestParallelTestRunner.this.resultRepository);
                ((ParallelTestRepository)this.one(TestParallelTestRunner.this.repository)).getSuite("suite");
                this.will(1.returnValue(TestParallelTestRunner.this.queue));
                ((ParallelTestResultRepository)this.one(TestParallelTestRunner.this.resultRepository)).recordTestResult(TestParallelTestRunner.this.suiteResult);
                ((ParallelTestResultRepository)this.one(TestParallelTestRunner.this.resultRepository)).closeAndWaitForCompletion();
            }
        });
    }

    @Test
    public void hasNoTests() throws IOException, InterruptedException {
        this.queue.offer(ParallelFitNesseRepository.TEST_SENTINEL);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SuiteResult)this.one(TestParallelTestRunner.this.suiteResult)).getCounts();
                this.will(2.returnValue((Object)TestParallelTestRunner.this.countsZero));
            }
        });
        ParallelTestRunner parallelTestRunner = new ParallelTestRunner(this.repository, this.testEngine, this.resultRepository);
        Assert.assertThat((Object)parallelTestRunner.runSuite("suite", this.suiteResult), (Matcher)CoreMatchers.equalTo((Object)this.countsZero));
    }

    @Test
    public void hasOneTest() throws IOException, InterruptedException {
        this.queue.offer(this.test1);
        this.queue.offer(ParallelFitNesseRepository.TEST_SENTINEL);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestEngine)this.one(TestParallelTestRunner.this.testEngine)).runTest(TestParallelTestRunner.this.test1);
                this.will(3.returnValue((Object)TestParallelTestRunner.this.result1));
                ((SuiteResult)this.one(TestParallelTestRunner.this.suiteResult)).append(TestParallelTestRunner.this.result1);
                ((ParallelTestResultRepository)this.one(TestParallelTestRunner.this.resultRepository)).recordTestResult(TestParallelTestRunner.this.result1);
                ((SuiteResult)this.one(TestParallelTestRunner.this.suiteResult)).getCounts();
                this.will(3.returnValue((Object)TestParallelTestRunner.this.countsOnes));
            }
        });
        ParallelTestRunner parallelTestRunner = new ParallelTestRunner(this.repository, this.testEngine, this.resultRepository);
        Assert.assertThat((Object)parallelTestRunner.runSuite("suite", this.suiteResult), (Matcher)CoreMatchers.equalTo((Object)this.countsOnes));
    }

    @Test
    public void hasTwoTests() throws IOException, InterruptedException {
        final InMemoryTestImpl inMemoryTestImpl = new InMemoryTestImpl("TestTwo", "Two Contents");
        final TestResult testResult = (TestResult)this.context.mock(TestResult.class, "testResult2");
        this.queue.offer(this.test1);
        this.queue.offer(inMemoryTestImpl);
        this.queue.offer(ParallelFitNesseRepository.TEST_SENTINEL);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestEngine)this.one(TestParallelTestRunner.this.testEngine)).runTest(TestParallelTestRunner.this.test1);
                this.will(4.returnValue((Object)TestParallelTestRunner.this.result1));
                ((SuiteResult)this.one(TestParallelTestRunner.this.suiteResult)).append(TestParallelTestRunner.this.result1);
                ((ParallelTestResultRepository)this.one(TestParallelTestRunner.this.resultRepository)).recordTestResult(TestParallelTestRunner.this.result1);
                ((TestEngine)this.one(TestParallelTestRunner.this.testEngine)).runTest(inMemoryTestImpl);
                this.will(4.returnValue((Object)testResult));
                ((SuiteResult)this.one(TestParallelTestRunner.this.suiteResult)).append(testResult);
                ((ParallelTestResultRepository)this.one(TestParallelTestRunner.this.resultRepository)).recordTestResult(testResult);
                ((SuiteResult)this.one(TestParallelTestRunner.this.suiteResult)).getCounts();
                this.will(4.returnValue((Object)TestParallelTestRunner.this.countsOnes));
            }
        });
        ParallelTestRunner parallelTestRunner = new ParallelTestRunner(this.repository, this.testEngine, this.resultRepository);
        Assert.assertThat((Object)parallelTestRunner.runSuite("suite", this.suiteResult), (Matcher)CoreMatchers.equalTo((Object)this.countsOnes));
    }
}

