/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.closure.LookupClosure;
import fitlibrary.closure.LookupMethodTargetStandard;
import fitlibrary.exception.NoSystemUnderTestException;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.flow.IScope;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.util.ArrayList;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestLookupMethodTarget {
    final LookupMethodTargetStandard lookup = new LookupMethodTargetStandard();
    final Mockery context = new Mockery();
    final Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class);
    final RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    final IScope scope = (IScope)this.context.mock(IScope.class);
    final LookupClosure lookupClosure = (LookupClosure)this.context.mock(LookupClosure.class);
    final Closure closure = (Closure)this.context.mock(Closure.class);
    final GenericTypedObject.MethodTargetFactory methodTargetFactory = (GenericTypedObject.MethodTargetFactory)this.context.mock(GenericTypedObject.MethodTargetFactory.class);
    final TypedObject typedObjectS = new GenericTypedObject("S", this.lookupClosure, this.methodTargetFactory);
    final TypedObject typedObjectT = new GenericTypedObject("T", this.lookupClosure, this.methodTargetFactory);

    @Before
    public void allowingExpectations() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getRuntimeContext();
                this.will(1.returnValue((Object)TestLookupMethodTarget.this.runtime));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("get unknown");
                this.will(1.returnValue((Object)"getUnknown"));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("is unknown");
                this.will(1.returnValue((Object)"isUnknown"));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("get m");
                this.will(1.returnValue((Object)"getM"));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("is m");
                this.will(1.returnValue((Object)"isM"));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("set m");
                this.will(1.returnValue((Object)"setM"));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("m");
                this.will(1.returnValue((Object)"m"));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("set unknown");
                this.will(1.returnValue((Object)"setUnknown"));
                ((RuntimeContextInternal)this.allowing(TestLookupMethodTarget.this.runtime)).extendedCamel("unknown");
                this.will(1.returnValue((Object)"unknown"));
            }
        });
    }

    @Test(expected=MissingMethodException.class)
    public void methodOrGetterMissingWithEmptyStack() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(2.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).objectsForLookup();
                this.will(2.returnValue(new ArrayList()));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).possibleClasses();
                this.will(2.returnValue(new ArrayList()));
            }
        });
        this.lookup.findMethodOrGetter("unknown", new ArrayList<String>(), "void", this.evaluator);
    }

    @Test(expected=MissingMethodException.class)
    public void methodOrGetterMissing() throws Exception {
        final ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        arrayList.add(this.typedObjectS);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(3.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).objectsForLookup();
                this.will(3.returnValue((Object)arrayList));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "unknown", 0);
                this.will(3.returnValue(null));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "getUnknown", 0);
                this.will(3.returnValue(null));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "isUnknown", 0);
                this.will(3.returnValue(null));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).possibleClasses();
                this.will(3.returnValue(new ArrayList()));
            }
        });
        this.lookup.findMethodOrGetter("unknown", new ArrayList<String>(), "void", this.evaluator);
    }

    @Test
    public void methodOrGetterExists() throws Exception {
        final ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        arrayList.add(this.typedObjectS);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(4.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).objectsForLookup();
                this.will(4.returnValue((Object)arrayList));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "m", 0);
                this.will(4.returnValue((Object)TestLookupMethodTarget.this.closure));
                ((GenericTypedObject.MethodTargetFactory)this.oneOf(TestLookupMethodTarget.this.methodTargetFactory)).createCalledMethodTarget(TestLookupMethodTarget.this.closure, TestLookupMethodTarget.this.evaluator);
            }
        });
        this.lookup.findMethodOrGetter("m", new ArrayList<String>(), "void", this.evaluator);
    }

    @Test
    public void methodOrGetterExistsOnSecondTypedObject() throws Exception {
        final ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        arrayList.add(this.typedObjectS);
        arrayList.add(this.typedObjectT);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(5.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).objectsForLookup();
                this.will(5.returnValue((Object)arrayList));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "m", 0);
                this.will(5.returnValue(null));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "getM", 0);
                this.will(5.returnValue(null));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "isM", 0);
                this.will(5.returnValue(null));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectT, "m", 0);
                this.will(5.returnValue((Object)TestLookupMethodTarget.this.closure));
                ((GenericTypedObject.MethodTargetFactory)this.oneOf(TestLookupMethodTarget.this.methodTargetFactory)).createCalledMethodTarget(TestLookupMethodTarget.this.closure, TestLookupMethodTarget.this.evaluator);
            }
        });
        this.lookup.findMethodOrGetter("m", new ArrayList<String>(), "void", this.evaluator);
    }

    @Test(expected=MissingMethodException.class)
    public void methodMissingWithEmptyStack() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(6.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).objectsForLookup();
                this.will(6.returnValue(new ArrayList()));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).possibleClasses();
                this.will(6.returnValue(new ArrayList()));
            }
        });
        this.lookup.findMethod("unknown", new ArrayList<String>(), "void", this.evaluator);
    }

    @Test(expected=MissingMethodException.class)
    public void methodMissing() throws Exception {
        final ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        arrayList.add(this.typedObjectS);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(7.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).objectsForLookup();
                this.will(7.returnValue((Object)arrayList));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "unknown", 0);
                this.will(7.returnValue(null));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).possibleClasses();
                this.will(7.returnValue(new ArrayList()));
            }
        });
        this.lookup.findMethod("unknown", new ArrayList<String>(), "void", this.evaluator);
    }

    @Test
    public void methodExistsOnSecondTypedObject() throws Exception {
        final ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        arrayList.add(this.typedObjectS);
        arrayList.add(this.typedObjectT);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(8.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).objectsForLookup();
                this.will(8.returnValue((Object)arrayList));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "m", 0);
                this.will(8.returnValue(null));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectT, "m", 0);
                this.will(8.returnValue((Object)TestLookupMethodTarget.this.closure));
                ((GenericTypedObject.MethodTargetFactory)this.oneOf(TestLookupMethodTarget.this.methodTargetFactory)).createCalledMethodTarget(TestLookupMethodTarget.this.closure, TestLookupMethodTarget.this.evaluator);
            }
        });
        this.lookup.findMethod("m", new ArrayList<String>(), "void", this.evaluator);
    }

    @Test(expected=NoSystemUnderTestException.class)
    public void setterMissingAsNoSut() throws Exception {
        ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        arrayList.add(this.typedObjectS);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getTypedSystemUnderTest();
                this.will(9.returnValue((Object)new GenericTypedObject(null)));
            }
        });
        this.lookup.findSetterOnSut("m", this.evaluator);
    }

    @Test(expected=MissingMethodException.class)
    public void setterMissing() throws Exception {
        ArrayList<TypedObject> arrayList = new ArrayList<TypedObject>();
        arrayList.add(this.typedObjectS);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getTypedSystemUnderTest();
                this.will(10.returnValue((Object)TestLookupMethodTarget.this.typedObjectS));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "setUnknown", 1);
                this.will(10.returnValue(null));
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getScope();
                this.will(10.returnValue((Object)TestLookupMethodTarget.this.scope));
                ((IScope)this.oneOf(TestLookupMethodTarget.this.scope)).possibleClasses();
                this.will(10.returnValue(new ArrayList()));
            }
        });
        this.lookup.findSetterOnSut("unknown", this.evaluator);
    }

    @Test
    public void setterExistsOnTypedObject() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestLookupMethodTarget.this.evaluator)).getTypedSystemUnderTest();
                this.will(11.returnValue((Object)TestLookupMethodTarget.this.typedObjectS));
                ((LookupClosure)this.oneOf(TestLookupMethodTarget.this.lookupClosure)).findMethodClosure(TestLookupMethodTarget.this.typedObjectS, "setM", 1);
                this.will(11.returnValue((Object)TestLookupMethodTarget.this.closure));
                ((GenericTypedObject.MethodTargetFactory)this.oneOf(TestLookupMethodTarget.this.methodTargetFactory)).createCalledMethodTarget(TestLookupMethodTarget.this.closure, TestLookupMethodTarget.this.evaluator);
            }
        });
        this.lookup.findSetterOnSut("m", this.evaluator);
    }
}

