/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.map;

import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MapSetUpTraverse
extends Traverse {
    private static Logger logger = FitLibraryLogger.getLogger(MapSetUpTraverse.class);
    private Map<Object, Object> theMap = new HashMap<Object, Object>();
    protected Parser keyParser;
    protected Parser valueParser;

    protected MapSetUpTraverse() {
    }

    public MapSetUpTraverse(Typed keyTyped, Typed valueTyped, RuntimeContextInternal runtimeContext) {
        this.runtimeContext = runtimeContext;
        this.keyParser = keyTyped.parser(this);
        this.valueParser = valueTyped.parser(this);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
                this.processRow((Row)table.at(rowNo), testResults);
            }
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        return this.theMap;
    }

    protected void processRow(Row row, TestResults testResults) throws Exception {
        try {
            if (row.size() != 2) {
                throw new RowWrongWidthException(2);
            }
            Object key = this.keyParser.parseTyped((Cell)row.at(0), testResults).getSubject();
            Object value = this.valueParser.parseTyped((Cell)row.at(1), testResults).getSubject();
            logger.trace((Object)("Put in map: " + key + " -> " + value));
            this.theMap.put(key, value);
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    public Map<Object, Object> getResults() {
        return this.theMap;
    }
}

