/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fit.exception.FitParseException;
import fitlibrary.definedAction.DefinedActionBodyCollector;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.matcher.TablesMatcher;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.utility.SimpleWikiTranslator;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestDefinedActionBodyCollectorWithList {
    Mockery context = new Mockery();
    DefinedActionBodyCollector collector = new DefinedActionBodyCollector();
    DefinedActionBodyCollector.DefineActionBodyConsumer consumer = (DefinedActionBodyCollector.DefineActionBodyConsumer)this.context.mock(DefinedActionBodyCollector.DefineActionBodyConsumer.class);

    @Test
    public void oneTableBody() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n\n|comment|")));
            }
        });
        this.check("|a|\n\n|comment|");
    }

    @Test
    public void twoTableBody() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n\n|comment|\n\n|comment2|\n")));
            }
        });
        this.check("|a|\n\n|comment|\n\n|comment2|\n");
    }

    @Test
    public void zeroTableBody() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n")));
            }
        });
        this.check("|a|\n");
    }

    @Test
    public void twoOneTableBodies() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n\n|comment|\n")));
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|b|\n\n|comment|\n")));
            }
        });
        this.check("|a|\n\n|comment|\n----\n|b|\n\n|comment|\n");
    }

    @Test
    public void threeOneTableBodies() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n\n|comment|\n")));
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|b|\n\n|comment|\n")));
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|c|\n\n|comment|\n")));
            }
        });
        this.check("|a|\n\n|comment|\n----\n|b|\n\n|comment|\n----\n|c|\n\n|comment|\n");
    }

    @Test
    public void twoOneTableBodiesWithHRatEnd() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n\n|comment|\n")));
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|b|\n\n|comment|\n")));
            }
        });
        this.check("|a|\n\n|comment|\n----\n|b|\n\n|comment|\n----\n");
    }

    @Test
    public void zeroTableBodyFirst() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n")));
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|b|\n\n|comment|\n")));
            }
        });
        this.check("|a|\n----\n|b|\n\n|comment|\n");
    }

    @Test
    public void zeroTableBodySecond() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|a|\n")));
                ((DefinedActionBodyCollector.DefineActionBodyConsumer)this.one(TestDefinedActionBodyCollectorWithList.this.consumer)).addAction((Tables)this.with((Matcher)TestDefinedActionBodyCollectorWithList.this.tablesMatcher("|b|\n")));
            }
        });
        this.check("|a|\n----\n|b|\n");
    }

    protected TablesMatcher tablesMatcher(String string) {
        return new TablesMatcher(this.makeTables(string), new GlobalDynamicVariables());
    }

    private void check(String string) {
        this.collector.parseDefinitions(this.makeTables(string), this.consumer);
    }

    protected Tables makeTables(String string) {
        try {
            Tables tables = SimpleWikiTranslator.translateToTablesOnList(string);
            ((Table)tables.at(0)).setLeader("");
            ((Table)tables.last()).setTrailer("");
            return tables;
        }
        catch (FitParseException fitParseException) {
            throw new RuntimeException(fitParseException.toString());
        }
    }
}

