/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.dynamicVariable;

import fitlibrary.dynamicVariable.DynamicVariablesMap;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.matcher.TablesMatcher;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestDynamicVariablesMap {
    DynamicVariablesMap vars = new GlobalDynamicVariables();
    DynamicVariablesMap emptyVars = new GlobalDynamicVariables();

    @Test
    public void noSubstitution() {
        this.verify(this.vars.resolve("ab"), "ab");
    }

    @Test
    public void oneStringSubstitution() {
        this.vars.put("ab", "AB");
        this.verify(this.vars.resolve("@{ab}"), "AB");
    }

    @Test
    public void twoStringSubstitutions() {
        this.vars.put("ab", "AB");
        this.vars.put("cd", "CD");
        this.verify(this.vars.resolve("@{ab}+@{cd}"), "AB+CD");
    }

    @Test
    public void xmlSubstitutions() {
        this.vars.put("ab", "<a>b</a>");
        this.vars.put("cd", "<c a='b'/>");
        this.verify(this.vars.resolve("@{ab}+@{cd}"), "&lt;a>b&lt;/a>+&lt;c a='b'/>");
    }

    @Test
    public void oneTablesSubstitutions() {
        Tables tables = TableFactory.tables(TableFactory.table(TableFactory.row("a", "b", "c")));
        this.vars.put("ab", tables);
        this.verify(this.vars.resolve("x@{ab}y"), "xy", tables);
    }

    @Test
    public void twoTablesSubstitutions() {
        Tables tables = TableFactory.tables(TableFactory.table(TableFactory.row("a", "b", "c")));
        this.vars.put("ab", tables);
        Tables tables2 = TableFactory.tables(TableFactory.table(TableFactory.row("c", "d")));
        this.vars.put("cd", tables2);
        Tables tables3 = TableFactory.tables(TableFactory.table(TableFactory.row("a", "b", "c")));
        tables3.addTables(tables2);
        this.verify(this.vars.resolve("x@{ab}y@{cd}z"), "xyz", tables3);
    }

    private void verify(Pair<String, Tables> pair, String string) {
        this.verify(pair, string, TableFactory.tables());
    }

    private void verify(Pair<String, Tables> pair, String string, Tables tables) {
        MatcherAssert.assertThat(pair.first, (Matcher)CoreMatchers.is((Object)string));
        MatcherAssert.assertThat(pair.second, (Matcher)new TablesMatcher(tables, this.emptyVars));
    }
}

