/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.exception;

import fit.Fixture;
import fitlibrary.exception.ExceptionHandling;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.FitLibraryExceptionInHtml;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.utility.ExceptionHandler;
import fitlibrary.utility.HtmlUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionHandlingStandard
implements ExceptionHandling {
    @Override
    public void mustBeThreadSafe() {
    }

    @Override
    public String exceptionMessage(Throwable throwable) {
        Throwable exception = this.unwrapThrowable(throwable);
        if (exception instanceof IgnoredException) {
            return "";
        }
        if (exception instanceof FitLibraryExceptionInHtml) {
            return "<hr/>" + Fixture.label(exception.getMessage());
        }
        if (exception instanceof FitLibraryException) {
            return "<hr/>" + Fixture.label(HtmlUtils.escapeHtml(exception.getMessage()));
        }
        StringWriter buf = new StringWriter();
        exception.printStackTrace(new PrintWriter(buf));
        return "<hr><pre><div class=\"fit_stacktrace\">" + buf.toString() + "</div></pre>";
    }

    @Override
    public Throwable unwrapThrowable(Throwable throwable) {
        return ExceptionHandler.unwrap(throwable);
    }

    @Override
    public boolean unwrappedIsShow(Exception e) {
        return this.unwrapThrowable(e) instanceof FitLibraryShowException;
    }
}

