/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fit.Fixture;
import fitlibrary.DefineAction;
import fitlibrary.DoFixture;
import fitlibrary.DomainFixture;
import fitlibrary.SelectFixture;
import fitlibrary.SetUpFixture;
import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.flow.DoFlowerOnTable;
import fitlibrary.flow.IScopeStack;
import fitlibrary.flow.SetUpTearDown;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.object.DomainFixtured;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibrary.typed.TypedObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DoFlowOnTable
implements DoFlowerOnTable {
    private static Logger logger = FitLibraryLogger.getLogger(DoFlowOnTable.class);
    private final FlowEvaluator flowEvaluator;
    private final IScopeStack scopeStack;
    private final SetUpTearDown setUpTearDown;
    private final DoFlower doFlower;
    private RuntimeContextInternal runtime;

    public DoFlowOnTable(FlowEvaluator flowEvaluator, IScopeStack scopeStack, SetUpTearDown setUpTearDown, DoFlower doFlower) {
        this.flowEvaluator = flowEvaluator;
        this.scopeStack = scopeStack;
        this.setUpTearDown = setUpTearDown;
        this.doFlower = doFlower;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTable(Table table, TestResults testResults, RuntimeContextInternal runtimeInternal) {
        this.runtime = runtimeInternal;
        runtimeInternal.setCurrentTable(table);
        runtimeInternal.pushTestResults(testResults);
        try {
            this.runTable(table, testResults);
        }
        finally {
            runtimeInternal.popTestResults();
        }
    }

    private void runTable(Table table, TestResults testResults) {
        for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
            Row row = (Row)table.at(rowNo);
            if (this.runtime.isAbandoned(testResults)) {
                row.ignore(testResults);
                continue;
            }
            if (this.doFlower.hasDomainCheck() && row.size() == 1 && row.text(0, this.flowEvaluator).equals("checks")) {
                this.doFlower.setDomainToCheck();
                continue;
            }
            try {
                Cell cell = (Cell)row.at(0);
                if (cell.hasEmbeddedTables(this.runtime.getResolver())) {
                    this.doFlower.runInnerTables(cell.getEmbeddedTables(), testResults);
                } else {
                    row = DoFlowOnTable.mapOddBalls(row, this.flowEvaluator);
                    this.runtime.setCurrentRow(row);
                    long startTime = System.currentTimeMillis();
                    TypedObject typedResult = this.flowEvaluator.interpretRow(row, testResults);
                    this.addTimeText(row, startTime);
                    Object subject = typedResult.getSubject();
                    if (subject != null && !(subject instanceof Boolean)) {
                        logger.trace((Object)("Interpreted  row #" + rowNo + " -> " + subject));
                    }
                    typedResult.injectRuntime(this.runtime);
                    if (subject != null && subject.getClass() != Fixture.class) {
                        if (subject.getClass() == DoFixture.class || subject.getClass() == DoTraverse.class) {
                            this.handleActualDoFixture((DoEvaluator)subject, row, testResults);
                        } else if (subject.getClass() == SelectFixture.class) {
                            this.runtime.showAsAfterTable("warning", "This is no longer needed");
                            this.handleActualDoFixture((DoEvaluator)subject, row, testResults);
                        } else if (subject instanceof DomainFixtured || subject instanceof DomainFixture) {
                            this.handleDomainFixture(typedResult, row, testResults);
                        } else if (subject instanceof SuiteEvaluator) {
                            this.handleSuiteFixture((SuiteEvaluator)subject, typedResult, row, testResults);
                        } else {
                            if (subject instanceof CollectionSetUpTraverse || subject instanceof SetUpFixture) {
                                this.runEvaluator(typedResult, (Evaluator)subject, rowNo, table, testResults);
                                return;
                            }
                            if (subject instanceof DoEvaluator) {
                                this.pushOnScope(typedResult, row, testResults);
                            } else {
                                if (subject instanceof Evaluator) {
                                    this.runEvaluator(typedResult, (Evaluator)subject, rowNo, table, testResults);
                                    return;
                                }
                                if (subject instanceof Fixture) {
                                    startTime = System.currentTimeMillis();
                                    Table remainingTable = ((Table)table.fromAt(rowNo)).asTableOnParse();
                                    this.flowEvaluator.fitHandler().doTable((Fixture)subject, remainingTable, testResults, this.flowEvaluator);
                                    for (int i = 0; i < remainingTable.size(); ++i) {
                                        table.replaceAt(rowNo + i, (Row)remainingTable.at(i));
                                    }
                                    this.addTimeText(row, startTime);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                row.error(testResults, ex);
            }
            if (!testResults.problems()) continue;
            this.runtime.checkStopOnError(testResults);
        }
    }

    private void addTimeText(Row row, long startTime) {
        if (this.runtime.getConfiguration().isAddTimings()) {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
            String tooltip = format.format(new Date(startTime)) + "\n" + format.format(new Date(endTime));
            if (elapsedTime > 0L) {
                row.addCell("<span class='note' title='" + tooltip + "'><i>" + elapsedTime + "</i> ms</span>");
            }
        }
    }

    private void runEvaluator(TypedObject typedResult, Evaluator subject, int rowNo, Table table, TestResults testResults) {
        Table restOfTable = (Table)table.fromAt(rowNo);
        int rest = restOfTable.size();
        Row row = (Row)table.at(rowNo);
        typedResult.injectRuntime(this.runtime);
        long startTime = System.currentTimeMillis();
        if (!(subject instanceof DefineAction)) {
            this.pushOnScope(typedResult, row, testResults);
        } else {
            this.callSetUpSutChain(subject, row, testResults);
        }
        subject.interpretAfterFirstRow(restOfTable, testResults);
        this.addTimeText(row, startTime);
        if (subject instanceof DefineAction) {
            this.setUpTearDown.callTearDownOnSutChain(subject, row, testResults);
        }
        if (restOfTable != table && restOfTable.size() > rest) {
            for (int i = rest; i < restOfTable.size(); ++i) {
                table.add(restOfTable.at(i));
            }
        }
    }

    private void handleActualDoFixture(DoEvaluator doEvaluator, Row row, TestResults testResults) {
        TypedObject typedSystemUnderTest = doEvaluator.getTypedSystemUnderTest();
        if (!typedSystemUnderTest.isNull()) {
            this.pushOnScope(typedSystemUnderTest, row, testResults);
            typedSystemUnderTest.injectRuntime(this.runtime);
        }
    }

    private void handleSuiteFixture(SuiteEvaluator suiteEvaluator, TypedObject typedResult, Row row, TestResults testResults) {
        this.doFlower.setSuite(suiteEvaluator);
        this.setUpTearDown.callSuiteSetUp(suiteEvaluator, row, testResults);
        this.pushOnScope(typedResult, row, testResults);
    }

    private void handleDomainFixture(TypedObject typedResult, Row row, TestResults testResults) {
        this.pushOnScope(typedResult, row, testResults);
        this.doFlower.setDomainFixture(typedResult);
    }

    private void pushOnScope(TypedObject typedResult, Row row, TestResults testResults) {
        this.scopeStack.push(typedResult);
        this.callSetUpSutChain(typedResult.getSubject(), row, testResults);
    }

    private void callSetUpSutChain(Object sutInitially, Row row, TestResults testResults) {
        this.setUpTearDown.callSetUpOnSutChain(sutInitially, row, testResults);
    }

    public static Row mapOddBalls(Row row, VariableResolver evaluator) {
        if (row.size() == 4 && "add".equals(row.text(0, evaluator)) && "as".equals(row.text(2, evaluator))) {
            String className = row.text(1, evaluator);
            ((Cell)row.at(0)).setText("add named");
            ((Cell)row.at(1)).setText(row.text(3, evaluator));
            ((Cell)row.at(2)).setText(className);
            row.removeElementAt(3);
        }
        return row;
    }

    public static interface DoFlower {
        public void runInnerTables(Tables var1, TestResults var2);

        public void setDomainFixture(TypedObject var1);

        public void setSuite(SuiteEvaluator var1);

        public boolean hasDomainCheck();

        public void setDomainToCheck();
    }
}

