/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.flow.DoFlow;
import fitlibrary.flow.IScopeStack;
import fitlibrary.flow.SetUpTearDown;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibrary.typed.TypedObject;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestDoFlowWithSelect {
    final Mockery context = new Mockery();
    final Row row = (Row)this.context.mock(Row.class);
    final FlowEvaluator flowEvaluator = (FlowEvaluator)this.context.mock(FlowEvaluator.class);
    final IScopeStack scopeStack = (IScopeStack)this.context.mock(IScopeStack.class);
    final Object something = "something";
    final TypedObject someTypedObject = (TypedObject)this.context.mock(TypedObject.class);
    final RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    final SetUpTearDown setUpTearDown = (SetUpTearDown)this.context.mock(SetUpTearDown.class);
    final DoFlow doFlow = new DoFlow(this.flowEvaluator, this.scopeStack, this.runtime, this.setUpTearDown);

    @Test(expected=FitLibraryException.class)
    public void selectUnknown() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((IScopeStack)this.oneOf(TestDoFlowWithSelect.this.scopeStack)).select("unknown");
                this.will(1.throwException((Throwable)new FitLibraryException("")));
            }
        });
        this.doFlow.select("unknown");
    }

    @Test
    public void addNamedObjectAndSelect() {
        final TestResults testResults = TestResultsFactory.testResults();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TypedObject)this.oneOf(TestDoFlowWithSelect.this.someTypedObject)).getSubject();
                this.will(2.returnValue((Object)TestDoFlowWithSelect.this.something));
                ((TypedObject)this.oneOf(TestDoFlowWithSelect.this.someTypedObject)).injectRuntime(TestDoFlowWithSelect.this.runtime);
                ((SetUpTearDown)this.oneOf(TestDoFlowWithSelect.this.setUpTearDown)).callSetUpOnSutChain(TestDoFlowWithSelect.this.something, TestDoFlowWithSelect.this.row, testResults);
                ((IScopeStack)this.oneOf(TestDoFlowWithSelect.this.scopeStack)).addNamedObject("x", TestDoFlowWithSelect.this.someTypedObject);
                ((IScopeStack)this.oneOf(TestDoFlowWithSelect.this.scopeStack)).select("x");
            }
        });
        this.doFlow.addNamedObject("x", this.someTypedObject, this.row, testResults);
        this.doFlow.select("x");
    }
}

