/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.log;

import fitlibrary.log.ConfigureLogger;
import fitlibrary.log.CustomHtmlLayout;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.log.FixturingLogger;
import fitlibrary.log.ShowAfterTableAppender;
import fitlibrary.runtime.RuntimeContextInternal;
import org.apache.log4j.Logger;

public class ConfigureLog4j {
    private final RuntimeContextInternal runtime;
    private final ShowAfterTableAppender appender;
    private final ConfigureLogger configureNormalLog4j;
    private final ConfigureLogger configureFitLibraryLogger;
    private final ConfigureLogger configureFixturingLogger;
    private ConfigureLogger currentLogger;

    public ConfigureLog4j(RuntimeContextInternal runtime) {
        this.runtime = runtime;
        this.appender = new ShowAfterTableAppender(runtime, new CustomHtmlLayout());
        this.configureNormalLog4j = new ConfigureLogger(this.appender){

            @Override
            protected Logger rootLogger() {
                return Logger.getRootLogger();
            }

            @Override
            protected Logger getLogger(String name) {
                return Logger.getLogger((String)name);
            }
        };
        this.configureFitLibraryLogger = new ConfigureLogger(this.appender){

            @Override
            protected Logger rootLogger() {
                return FitLibraryLogger.getRootLogger();
            }

            @Override
            protected Logger getLogger(String name) {
                return FitLibraryLogger.getLogger(name);
            }
        };
        this.currentLogger = this.configureFixturingLogger = new ConfigureLogger(this.appender){

            @Override
            protected Logger rootLogger() {
                return FixturingLogger.getRootLogger();
            }

            @Override
            protected Logger getLogger(String name) {
                return FixturingLogger.getLogger(name);
            }
        };
    }

    public ConfigureLogger withNormalLog4j() {
        return this.configureNormalLog4j;
    }

    public ConfigureLogger withFitLibraryLogger() {
        return this.configureFitLibraryLogger;
    }

    public ConfigureLogger withFixturingLogger() {
        return this.configureFixturingLogger;
    }

    public void log(String s) {
        this.currentLogger.getLogger(this.runtime.getDefinedActionCallManager().topName()).debug((Object)s);
    }
}

