/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser;

import fitlibrary.DoFixture;
import fitlibrary.parser.Parser;
import fitlibrary.parser.ParserTestCase;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.ref.EntityReference;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.table.Cell;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.NonGenericTyped;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestReferenceParser
extends TestCase {
    List<MyClass> list;
    public MyClass aProp;
    DoFixture doFixture = ParserTestCase.evaluatorWithRuntime(new MyDoFixture());

    public void setUp() {
        this.list = new ArrayList<MyClass>();
        this.list.add(new MyClass(1));
        this.list.add(new MyClass(2));
        this.list.add(new MyClass(3));
        this.aProp = this.list.get(1);
    }

    public void testParseAlone() throws Exception {
        Parser parser = new NonGenericTyped(MyClass.class).parser(this.doFixture);
        MyClass myClass = this.list.get(0);
        this.checkReference(parser, "the", myClass);
        this.checkReference(parser, "the first", myClass);
        this.checkReference(parser, "the first MyClass", myClass);
        this.checkReference(parser, "the first myClass", myClass);
        this.checkReference(parser, "1st", myClass);
        TestReferenceParser.assertEquals((String)"the second MyClass", (String)parser.show(this.list.get(1)));
        TestReferenceParser.assertEquals((String)"the third MyClass", (String)parser.show(this.list.get(2)));
    }

    private void checkReference(Parser parser, String string, Object object) throws Exception {
        Cell cell = TableFactory.cell(string);
        TestResults testResults = TestResultsFactory.testResults();
        TestReferenceParser.assertEquals((Object)object, (Object)parser.parseTyped(cell, testResults).getSubject());
        TestReferenceParser.assertTrue((boolean)parser.matches(cell, object, testResults));
        TestReferenceParser.assertEquals((String)"the first MyClass", (String)parser.show(object));
    }

    public void testParseFails() throws Exception {
        Parser parser = Traverse.asTyped(MyClass.class).parser(this.doFixture);
        this.checkReferenceFails(parser, "th");
        this.checkReferenceFails(parser, "the forst");
        this.checkReferenceFails(parser, "the first My Class");
        this.checkReferenceFails(parser, "the first myClass.");
        this.checkReferenceFails(parser, "2nd");
    }

    private void checkReferenceFails(Parser parser, String string) {
        try {
            Cell cell = TableFactory.cell(string);
            parser.parseTyped(cell, TestResultsFactory.testResults());
            TestReferenceParser.fail((String)("Should throw and exception with '" + string + "'"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testParseWithMethod() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ResultParser resultParser = Traverse.asTypedObject((Object)this).resultParser((Evaluator)this.doFixture, method);
        resultParser.setTarget((Object)this);
        TestReferenceParser.assertEquals((Object)this.list.get(2), (Object)resultParser.getResult());
        TestReferenceParser.assertEquals((String)"the third MyClass", (String)resultParser.show(resultParser.getResult()));
    }

    public MyClass aMethod() {
        return this.list.get(2);
    }

    public static class MyClass {
        private int value;

        public MyClass(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "MyClass-" + this.value;
        }
    }

    public class MyDoFixture
    extends DoFixture {
        public MyClass findMyClass(int n) {
            return TestReferenceParser.this.list.get(n);
        }

        public MyClass findMyClass(String string) {
            if ("1st".equals(string)) {
                return this.findMyClass(0);
            }
            throw new RuntimeException("Unavailable: MyClass from '" + string + "'");
        }

        public String showMyClass(MyClass myClass) {
            return EntityReference.reference(myClass, TestReferenceParser.this.list);
        }

        public MyClass aMethod() {
            return TestReferenceParser.this.list.get(2);
        }
    }
}

