/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.collection;

import fitlibrary.parser.Parser;
import fitlibrary.parser.ParserTestCase;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.table.Cell;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.NonGenericTyped;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.Method;

public class TestArrayParser
extends ParserTestCase {
    public int[] aProp = new int[]{5, 6, 7};

    public void testAdapterAlone() throws Exception {
        int[] nArray = new int[]{1, 2, 3};
        Parser parser = new NonGenericTyped(nArray.getClass()).parser(TestArrayParser.evaluatorWithRuntime());
        String string = "1, 2, 3";
        Cell cell = TableFactory.cell(string);
        int[] nArray2 = new int[]{1, 2, 3};
        this.assertArrayEquals(nArray2, (int[])parser.parseTyped(cell, TestResultsFactory.testResults()).getSubject());
        TestArrayParser.assertTrue((boolean)parser.matches(cell, nArray2, TestResultsFactory.testResults()));
        TestArrayParser.assertEquals((String)string, (String)parser.show(nArray2));
    }

    private void assertArrayEquals(int[] nArray, int[] nArray2) {
        TestArrayParser.assertEquals((int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray2.length; ++i) {
            TestArrayParser.assertEquals((String)("Element #" + i), (int)nArray[i], (int)nArray2[i]);
        }
    }

    public void testAdapterWithMethod() throws Exception {
        int[] nArray = new int[]{4, 5, 6};
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ResultParser resultParser = new GenericTypedObject((Object)this).resultParser((Evaluator)TestArrayParser.evaluatorWithRuntime(), method);
        resultParser.setTarget((Object)this);
        Object object = resultParser.getResult();
        TestArrayParser.assertEquals(nArray.getClass(), object.getClass());
        this.assertArrayEquals(nArray, (int[])object);
        TestArrayParser.assertEquals((String)"4, 5, 6", (String)resultParser.show(resultParser.getResult()));
    }

    public int[] aMethod() {
        return new int[]{4, 5, 6};
    }

    public void testAdapterWithProperty() throws Exception {
        int[] nArray = new int[]{5, 6, 7};
        Parser parser = Traverse.asTyped(nArray).parser(TestArrayParser.evaluatorWithRuntime());
        TestArrayParser.assertEquals((String)"5, 6, 7", (String)parser.show(nArray));
        Object object = parser.parseTyped(TableFactory.cell("5,6,7"), TestResultsFactory.testResults()).getSubject();
        int[] nArray2 = (int[])object;
        this.assertArrayEquals(nArray2, nArray);
    }
}

