/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Parse;
import fitlibrary.differences.FolderRunnerDifference;
import fitlibrary.runner.CollectSetUpTearDown;
import fitlibrary.runner.CopyFiles;
import fitlibrary.runner.CopyFilesFromJar;
import fitlibrary.runner.FileParseUtilities;
import fitlibrary.runner.Report;
import fitlibrary.runner.RunFile;
import fitlibrary.runner.StoryTestListener;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.traverse.Traverse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class FolderRunner
extends FileParseUtilities {
    public static final String FILES = "files";
    public static final String INDEX_HTML = "reportIndex.html";
    protected String encoding = "ASCII";
    private Report topReport;
    private List<StoryTestListener> testListeners = new ArrayList<StoryTestListener>();
    private File inDiry;
    private File reportDiry;
    private File suiteFile;
    private BatchFitLibrary batchFitLibrary = new BatchFitLibrary();
    private RunFile runFile;

    public static void main(String[] args) throws ParseException, IOException {
        Report report = new FolderRunner(args).run();
        report.exit();
    }

    public FolderRunner() {
        Traverse.setDifferenceStrategy(new FolderRunnerDifference());
    }

    public FolderRunner(String[] args) {
        this();
        int prefixArgs = 0;
        if (args.length > 1 && args[0].equals("-s")) {
            prefixArgs = 2;
            this.setSuiteFile(args[1]);
        }
        switch (args.length - prefixArgs) {
            case 0: {
                this.setTestFile("tests");
                break;
            }
            case 1: {
                this.setTestFile(args[prefixArgs]);
                break;
            }
            case 2: {
                this.setFiles(args[prefixArgs], args[prefixArgs + 1]);
                break;
            }
            case 3: {
                this.setFiles(args[prefixArgs], args[prefixArgs + 1]);
                this.encoding = args[prefixArgs + 2];
                break;
            }
            default: {
                System.err.println("Usage: java fitlibrary.runner.FolderRunner\nOr:    java fitlibrary.runner.FolderRunner testFolder\nOr:    java fitlibrary.runner.FolderRunner testFolder reportFolder\nOr:    java fitlibrary.runner.FolderRunner testFolder reportFolder unicodeEncodingOr:    java fitlibrary.runner.FolderRunner -s suiteFileName testFolder\nOr:    java fitlibrary.runner.FolderRunner -s suiteFileName testFolder reportFolder\nOr:    java fitlibrary.runner.FolderRunner -s suiteFileName testFolder reportFolder unicodeEncoding");
                System.exit(-1);
            }
        }
    }

    private void setSuiteFile(String fileName) {
        this.suiteFile = new File(fileName);
    }

    public Report run(String testDiry) throws ParseException, IOException {
        this.runFile = new RunFile(this.encoding, this.testListeners, this.batchFitLibrary);
        this.setTestFile(testDiry);
        return this.run();
    }

    public Report run(String theInDiry, String theReportDiry) throws ParseException, IOException {
        this.setFiles(theInDiry, theReportDiry);
        return this.run();
    }

    public Report run() throws ParseException, IOException {
        this.runFile = new RunFile(this.encoding, this.testListeners, this.batchFitLibrary);
        if (!this.inDiry.exists() || !this.inDiry.isDirectory()) {
            throw new RuntimeException("Folder is needed for input: " + this.inDiry.getAbsolutePath());
        }
        if (this.reportDiry.exists()) {
            if (!this.reportDiry.isDirectory()) {
                throw new RuntimeException("File exists but is not a directory: " + this.reportDiry.getAbsolutePath());
            }
        } else if (!this.reportDiry.mkdir()) {
            throw new RuntimeException("Unable to create folder " + this.reportDiry.getAbsolutePath());
        }
        if (this.reportDiry.getAbsolutePath().startsWith(this.inDiry.getAbsolutePath())) {
            throw new RuntimeException("The reports folder can't be inside the tests folder: it'll run forever!");
        }
        CopyFilesFromJar.copyCssAndImageFilesFromJar(this.inDiry);
        Parse setUpTables = new Parse("table", "", null, null);
        Parse tearDownTables = null;
        String title = "";
        File topReportDiry = this.reportDiry;
        this.topReport = new Report("FolderRunner", this.reportDiry, "", topReportDiry);
        File reportFile = new File(this.reportDiry, INDEX_HTML);
        if (FolderRunner.fileIsLocked(reportFile)) {
            throw new RuntimeException("Already running");
        }
        if (this.suiteFile != null) {
            this.runSuite(this.suiteFile, this.reportDiry, this.topReport, setUpTables, tearDownTables);
        }
        this.runDiry(title, this.inDiry, this.reportDiry, this.topReport, setUpTables, tearDownTables, "", topReportDiry);
        this.giveFeedbackToUser();
        this.suiteFinished();
        this.topReport.setFinished();
        this.writeReport(reportFile, this.topReport);
        return this.topReport;
    }

    private void runDiry(String title, File theInDiry, File theReportDiry, Report parentReport, Parse setUpTables, Parse tearDownTables, String path, File topReportDiry) throws ParseException, IOException, SecurityException {
        FolderRunnerDifference.setCurrentTestDiryFile(theInDiry);
        Report report = new Report(title, theReportDiry, parentReport, path, topReportDiry);
        CollectSetUpTearDown collectSetUpTearDown = new CollectSetUpTearDown(this.encoding);
        Parse fullSetUpTables = collectSetUpTearDown.appendSetUp(setUpTables, theInDiry);
        Parse fullTearDownTables = collectSetUpTearDown.prependTearDown(tearDownTables, theInDiry);
        File filesFile = new File(theInDiry, FILES);
        if (filesFile.exists()) {
            CopyFiles.copyFilesRecursively(theInDiry, theReportDiry, FILES);
        }
        File[] files = theInDiry.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.giveFeedbackToUser();
            File file = files[i];
            String name = file.getName();
            if (file.isDirectory()) {
                if (!this.canRunThisFolder(name)) continue;
                File subReportDiry = new File(theReportDiry, name);
                if (!subReportDiry.exists()) {
                    subReportDiry.mkdir();
                }
                this.runDiry(title + "." + file.getName(), file, subReportDiry, report, fullSetUpTables, fullTearDownTables, path + "../", topReportDiry);
                FolderRunnerDifference.setCurrentTestDiryFile(theInDiry);
                continue;
            }
            if (CollectSetUpTearDown.specialFileName(name)) continue;
            this.runFile(file, theReportDiry, report, fullSetUpTables, fullTearDownTables);
        }
        report.setFinished();
    }

    private void writeReport(File reportFile, Report report) throws IOException {
        Report reportToWrite = report;
        if (report.hasSingleChild()) {
            reportToWrite = report.firstChild();
        }
        PrintWriter output = new PrintWriter(new BufferedWriter(new FileWriter(reportFile)));
        output.print(reportToWrite.getHtml());
        output.close();
    }

    private void runSuite(File theSuiteFile, File theReportDiry, Report parentReport, Parse setUpTables, Parse tearDownTables) {
        if (!theSuiteFile.exists() || theSuiteFile.isDirectory()) {
            throw new RuntimeException("Suite file doesn't exist or is not a file: " + theSuiteFile);
        }
        Report report = new Report(theSuiteFile.getName(), theReportDiry, parentReport, "", theReportDiry);
        this.runFile(theSuiteFile, theReportDiry, report, setUpTables, tearDownTables);
        report.setFinished();
    }

    private boolean canRunThisFolder(String name) {
        return !name.equals(FILES) && !name.startsWith(".") && !name.equals("CVS");
    }

    private void runFile(File file, File theReportDiry, Report report, Parse fullSetUpTables, Parse fullTearDownTables) {
        this.runFile.runFile(file, theReportDiry, report, fullSetUpTables, fullTearDownTables);
    }

    private void setTestFile(String testDiryName) {
        this.inDiry = new File(testDiryName);
        this.reportDiry = new File(this.inDiry.getParentFile(), "reports");
    }

    private void setFiles(String testDiryName, String reportDiryName) {
        this.inDiry = new File(testDiryName);
        this.reportDiry = new File(reportDiryName);
    }

    public void addTestListener(StoryTestListener listener) {
        this.testListeners.add(listener);
    }

    private void giveFeedbackToUser() {
        for (StoryTestListener listener : this.testListeners) {
            listener.testComplete(this.topReport.failing(), this.topReport.getCounts(), this.topReport.getAssertionCounts());
        }
    }

    private void suiteFinished() {
        for (StoryTestListener listener : this.testListeners) {
            listener.suiteComplete();
        }
    }

    public void exit() {
        this.topReport.exit();
    }
}

