/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fitlibrary.runner.FolderRunner;
import fitlibrary.runner.StoryTestListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FolderRunnerUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final JTextField pageCounts = new JTextField();
    private final JTextField assertionCounts = new JTextField();
    private final JButton stopButton = new JButton("Quit");
    private final JTextArea textArea = new JTextArea();

    public static void main(String[] args) {
        new FolderRunnerUI(new FolderRunner(args));
    }

    public FolderRunnerUI(final FolderRunner runner) {
        super("FolderRunner");
        runner.addTestListener(new StoryTestListener(){

            @Override
            public void testComplete(boolean failing, String thePageCounts, String theAssertionCounts) {
                FolderRunnerUI.this.giveFeedbackToUser(failing, thePageCounts, theAssertionCounts);
            }

            @Override
            public void reportOutput(String name, String out, String output) {
                FolderRunnerUI.this.reportOut(name, out, output);
            }

            @Override
            public void suiteComplete() {
                FolderRunnerUI.this.setTitle(FolderRunnerUI.this.getTitle() + " -- finished");
            }
        });
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.makeTextFields(), "North");
        this.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
        this.getContentPane().add((Component)this.stopButton, "South");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                runner.exit();
            }
        });
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 500, 500);
        this.setVisible(true);
        try {
            runner.run();
        }
        catch (Exception e) {
            this.textArea.setText(this.textArea.getText() + "\n\n" + e.getMessage());
        }
    }

    private JPanel makeTextFields() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.pageCounts, "North");
        panel.add((Component)this.assertionCounts, "South");
        this.pageCounts.setFont(new Font("Arial", 1, 16));
        this.assertionCounts.setFont(new Font("Arial", 1, 16));
        return panel;
    }

    public void giveFeedbackToUser(boolean failing, String pageCounts2, String assertionCounts2) {
        this.pageCounts.setText(pageCounts2);
        this.assertionCounts.setText(assertionCounts2);
        Color color = Color.GREEN;
        if (failing) {
            color = Color.RED;
        }
        this.pageCounts.setBackground(color);
        this.assertionCounts.setBackground(color);
        this.validate();
    }

    public void reportOut(String name, String out, String output) {
        if (!output.trim().equals("")) {
            this.textArea.setText(this.textArea.getText() + "\n\n--------Output of " + out + " of " + name + ":--------\n" + output);
        }
    }
}

