/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.runResults.TestResults;
import fitlibrary.spec.SpecifyErrorReport;
import fitlibrary.spec.SpecifyErrorReported;
import fitlibrary.spec.TablesCompare;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.suite.StorytestRunner;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;

public class SpecifyFixture
extends Traverse {
    protected final StorytestRunner runner;
    protected final SpecifyErrorReport errorReport;
    protected final TablesCompare tablesCompare;

    public SpecifyFixture() {
        this.runner = new BatchFitLibrary();
        this.errorReport = new SpecifyErrorReported(this);
        this.tablesCompare = new TablesCompare(this.errorReport, this);
    }

    public SpecifyFixture(StorytestRunner runner, SpecifyErrorReport errorReport) {
        this.runner = runner;
        this.errorReport = errorReport;
        this.tablesCompare = new TablesCompare(errorReport, this);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            Cell actualCell = (Cell)((Row)table.at(1)).at(0);
            if (actualCell.isEmpty()) {
                throw new FitLibraryException("Missing nested tables to be run");
            }
            Cell expectedCell = this.expectedOf(table);
            Tables expectedTables = expectedCell.getActualEmbeddedTables();
            Tables actualTables = actualCell.getActualEmbeddedTables();
            this.runner.doStorytest(actualTables);
            if (this.tablesCompare.tablesEqual("", actualTables, expectedTables)) {
                expectedCell.pass(testResults);
                testResults.addRights(this.cellCount(actualTables) - 1);
            } else {
                expectedCell.fail(testResults);
                this.errorReport.actualResult(actualTables);
            }
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        return null;
    }

    private Cell expectedOf(Table table) {
        if (table.size() == 2 && ((Row)table.at(1)).size() == 2) {
            return (Cell)((Row)table.at(1)).at(1);
        }
        if (table.size() == 3 && ((Row)table.at(1)).size() == 1 && ((Row)table.at(2)).size() == 1) {
            return (Cell)((Row)table.at(2)).at(0);
        }
        throw new FitLibraryException("Table must have one row with two cells or two rows with one cell");
    }

    protected int cellCount(Tables tables) {
        int count = 0;
        for (Table table : tables) {
            for (Row row : table) {
                for (Cell cell : row) {
                    ++count;
                    count += this.cellCount(cell);
                }
            }
        }
        return count;
    }
}

